/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.sisu;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.remotable.sisu.BundleDisposer;
import com.atlassian.plugin.remotable.sisu.PluginEventIntegration;
import com.atlassian.plugin.remotable.sisu.PostConstructAnnotatedMethodTypeListener;
import com.atlassian.plugin.remotable.sisu.PreDestroyAbstractAnnotatedMethodTypeListener;
import com.atlassian.plugin.remotable.sisu.PublicComponentAnnotatedClassTypeListener;
import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matchers;
import org.ops4j.peaberry.Peaberry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class RemotableModule
extends AbstractModule {
    private final Bundle bundle;

    public RemotableModule(Bundle bundle) {
        this.bundle = (Bundle)Preconditions.checkNotNull((Object)bundle);
    }

    @Override
    protected void configure() {
        BundleContext bundleContext = this.bundle.getBundleContext();
        this.install(Peaberry.osgiModule(bundleContext));
        this.bind(ModuleFactory.class).toInstance((ModuleFactory)bundleContext.getService(bundleContext.getServiceReference(ModuleFactory.class.getName())));
        this.bind(Plugin.class).toInstance(((PluginRetrievalService)bundleContext.getService(bundleContext.getServiceReference(PluginRetrievalService.class.getName()))).getPlugin());
        this.bind(PluginEventIntegration.class).asEagerSingleton();
        this.registerPostConstructHandler();
        this.registerPreDestroyHandler();
        this.registerPublicComponentHandler();
    }

    private void registerPublicComponentHandler() {
        this.bindListener(Matchers.any(), new PublicComponentAnnotatedClassTypeListener(this.bundle.getBundleContext()));
    }

    private void registerPreDestroyHandler() {
        BundleDisposer disposer = new BundleDisposer(this.bundle);
        this.bindListener(Matchers.any(), new PreDestroyAbstractAnnotatedMethodTypeListener(disposer));
    }

    private void registerPostConstructHandler() {
        this.bindListener(Matchers.any(), new PostConstructAnnotatedMethodTypeListener());
    }
}

