/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.sisu;

import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class ContextClassLoaderSettingInvocationHandler
implements InvocationHandler {
    private final Supplier<Object> service;
    private final Option<String> toString;

    ContextClassLoaderSettingInvocationHandler(Supplier<Object> service, Option<String> toString) {
        this.service = Suppliers.memoize((Supplier)((Supplier)Preconditions.checkNotNull(service)));
        this.toString = (Option)Preconditions.checkNotNull(toString);
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if (this.toString.isDefined() && this.isToString(method)) {
            return this.toString.get();
        }
        return this.invokeOnService(method, objects);
    }

    private Object invokeOnService(Method method, Object[] objects) throws Throwable {
        Thread thread = Thread.currentThread();
        ClassLoader ccl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.service.get().getClass().getClassLoader());
            Object object = method.invoke(this.service.get(), objects);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            thread.setContextClassLoader(ccl);
        }
    }

    private boolean isToString(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }
}

