/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.confluence.rest;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.remotable.plugin.module.confluence.MacroContentManager;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Function;
import com.google.common.base.Suppliers;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/macro")
@AnonymousAllowed
public class MacroResource {
    private final MacroContentManager macroContentManager;

    public MacroResource(MacroContentManager macroContentManager) {
        this.macroContentManager = macroContentManager;
    }

    @Path(value="/app/{appKey}")
    @DELETE
    public Response clearMacrosFromPluginKey(@Context HttpServletRequest request, @PathParam(value="appKey") String appKey) {
        if (this.isAuthorisedConsumer(request, appKey)) {
            this.macroContentManager.clearContentByPluginKey(appKey);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Path(value="/app/{appKey}/{key}")
    @DELETE
    public Response clearMacro(@Context HttpServletRequest request, @PathParam(value="appKey") String appKey, @PathParam(value="key") String macroInstanceKey) {
        if (this.isAuthorisedConsumer(request, appKey)) {
            this.macroContentManager.clearContentByInstance(appKey, macroInstanceKey);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    private boolean isAuthorisedConsumer(HttpServletRequest request, final String appKey) {
        return (Boolean)this.getConsumerKeyFromRequest(request).fold(Suppliers.ofInstance((Object)Boolean.FALSE), (Function)new Function<String, Boolean>(){

            public Boolean apply(String key) {
                return key.equals(appKey);
            }
        });
    }

    private Option<String> getConsumerKeyFromRequest(HttpServletRequest request) {
        return Option.option((Object)((String)request.getAttribute("Plugin-Key")));
    }
}

