/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.jira.projectconfig;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DescriptorToRegister;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DynamicDescriptorRegistration;
import com.atlassian.plugin.remotable.plugin.module.ConditionProcessor;
import com.atlassian.plugin.remotable.plugin.module.IFrameParamsImpl;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.plugin.module.jira.projectconfig.IFrameProjectConfigWebPanel;
import com.atlassian.plugin.remotable.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.remotable.plugin.util.OsgiServiceUtils;
import com.atlassian.plugin.remotable.spi.module.IFrameParams;
import com.atlassian.plugin.remotable.spi.module.IFrameViewIssuePanel;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.DefaultWebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;
import org.osgi.framework.BundleContext;

public class ProjectConfigWebPanelModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private static final String PROJECT_WEB_PANEL_LOCATION = "webpanels.admin.summary";
    private final IFrameRendererImpl iFrameRenderer;
    private final DynamicDescriptorRegistration dynamicDescriptorRegistration;
    private final HostContainer hostContainer;
    private final BundleContext bundleContext;
    private final ConditionProcessor conditionProcessor;
    private Element descriptor;
    private String weight;
    private URI url;
    private DynamicDescriptorRegistration.Registration registration;
    private String location;

    public ProjectConfigWebPanelModuleDescriptor(ModuleFactory moduleFactory, IFrameRendererImpl iFrameRenderer, DynamicDescriptorRegistration dynamicDescriptorRegistration, HostContainer hostContainer, BundleContext bundleContext, ConditionProcessor conditionProcessor) {
        super(moduleFactory);
        this.iFrameRenderer = (IFrameRendererImpl)Preconditions.checkNotNull((Object)iFrameRenderer);
        this.dynamicDescriptorRegistration = (DynamicDescriptorRegistration)Preconditions.checkNotNull((Object)dynamicDescriptorRegistration);
        this.hostContainer = (HostContainer)Preconditions.checkNotNull((Object)hostContainer);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.conditionProcessor = (ConditionProcessor)Preconditions.checkNotNull((Object)conditionProcessor);
    }

    public Void getModule() {
        return null;
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.descriptor = element;
        this.location = this.getLocation(element);
        this.weight = Dom4jUtils.getOptionalAttribute(element, "weight", null);
        this.url = Dom4jUtils.getRequiredUriAttribute(element, "url");
    }

    public void enabled() {
        super.enabled();
        String moduleKey = "project-config-panel-" + Dom4jUtils.getRequiredAttribute(this.descriptor, "key");
        String panelName = Dom4jUtils.getRequiredAttribute(this.descriptor, "name");
        Element desc = this.descriptor.createCopy();
        desc.addAttribute("key", moduleKey);
        desc.addAttribute("i18n-key", panelName);
        desc.addAttribute("location", this.location);
        if (this.weight != null) {
            desc.addAttribute("weight", this.weight);
        }
        desc.addElement("label").addAttribute("key", panelName);
        desc.addAttribute("class", IFrameViewIssuePanel.class.getName());
        ModuleDescriptor<WebPanel> moduleDescriptor = this.createWebPanelModuleDescriptor(moduleKey, desc, new IFrameParamsImpl(this.descriptor));
        this.registration = this.dynamicDescriptorRegistration.registerDescriptors(this.getPlugin(), new DescriptorToRegister(moduleDescriptor));
    }

    public void disabled() {
        super.disabled();
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    private ModuleDescriptor<WebPanel> createWebPanelModuleDescriptor(final String moduleKey, Element desc, final IFrameParams iFrameParams) {
        try {
            DefaultWebPanelModuleDescriptor moduleDescriptor = new DefaultWebPanelModuleDescriptor(this.hostContainer, new ModuleFactory(){

                public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
                    return (T)new IFrameProjectConfigWebPanel(ProjectConfigWebPanelModuleDescriptor.this.iFrameRenderer, new IFrameContextImpl(ProjectConfigWebPanelModuleDescriptor.this.getPluginKey(), ProjectConfigWebPanelModuleDescriptor.this.url, moduleKey, iFrameParams));
                }
            }, OsgiServiceUtils.getService(this.bundleContext, WebInterfaceManager.class));
            moduleDescriptor.init(this.conditionProcessor.getLoadablePlugin(this.getPlugin()), desc);
            return moduleDescriptor;
        }
        catch (Exception ex) {
            throw new PluginParseException((Throwable)ex);
        }
    }

    private String getLocation(Element element) {
        String location = Dom4jUtils.getOptionalAttribute(element, "location", null);
        if (StringUtils.isEmpty((CharSequence)location) || location.equals("left")) {
            return "webpanels.admin.summary.left-panels";
        }
        if (location.equals("right")) {
            return "webpanels.admin.summary.right-panels";
        }
        throw new PluginParseException("project-config-panel is missing valid location.");
    }
}

