/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http.bigpipe;

import com.atlassian.plugin.remotable.api.service.http.bigpipe.BigPipeManager;
import com.atlassian.plugin.remotable.host.common.service.RequestContextServiceFactory;
import com.atlassian.plugin.remotable.host.common.service.TypedServiceFactory;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.DefaultBigPipeManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.concurrent.ScheduledExecutorService;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.DisposableBean;

public class BigPipeServiceFactory
implements TypedServiceFactory<BigPipeManager>,
DisposableBean {
    private final Cache<Bundle, BigPipeManager> instances;
    private final ScheduledExecutorService cleanupThread = DefaultBigPipeManager.createCleanupThread();

    public BigPipeServiceFactory(final RequestContextServiceFactory requestContextServiceFactory) {
        this.instances = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<Bundle, BigPipeManager>(){

            public BigPipeManager load(Bundle bundle) throws Exception {
                return new DefaultBigPipeManager(requestContextServiceFactory.getService(bundle), BigPipeServiceFactory.this.cleanupThread);
            }
        });
    }

    @Override
    public BigPipeManager getService(Bundle bundle) {
        return (BigPipeManager)this.instances.getUnchecked((Object)bundle);
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return this.getService(bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        this.instances.cleanUp();
    }

    public void destroy() throws Exception {
        this.instances.cleanUp();
        this.cleanupThread.shutdownNow();
    }
}

