/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.Request;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.plugin.remotable.plugin.util.OAuthHelper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthServiceProvider;
import net.oauth.OAuthValidator;
import net.oauth.SimpleOAuthValidator;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OAuthLinkManager {
    public static final String CONSUMER_KEY_OUTBOUND = "consumerKey.outbound";
    public static final String SERVICE_PROVIDER_REQUEST_TOKEN_URL = "serviceProvider.requestTokenUrl";
    public static final String SERVICE_PROVIDER_ACCESS_TOKEN_URL = "serviceProvider.accessTokenUrl";
    public static final String SERVICE_PROVIDER_AUTHORIZE_URL = "serviceProvider.authorizeUrl";
    private static final Logger log = LoggerFactory.getLogger(OAuthLinkManager.class);
    private final ServiceProviderConsumerStore serviceProviderConsumerStore;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ApplicationLinkService applicationLinkService;
    private final ConsumerService consumerService;
    private final OAuthValidator oauthValidator;

    @Autowired
    public OAuthLinkManager(ServiceProviderConsumerStore serviceProviderConsumerStore, AuthenticationConfigurationManager authenticationConfigurationManager, ApplicationLinkService applicationLinkService, ConsumerService consumerService) {
        this.serviceProviderConsumerStore = serviceProviderConsumerStore;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.applicationLinkService = applicationLinkService;
        this.consumerService = consumerService;
        this.oauthValidator = new SimpleOAuthValidator();
    }

    public void associateConsumerWithLink(ApplicationLink link, Consumer consumer) {
        this.unassociateConsumer(consumer);
        this.serviceProviderConsumerStore.put(consumer);
        link.putProperty("oauth.incoming.consumerkey", (Object)consumer.getKey());
    }

    public void unassociateConsumer(Consumer consumer) {
        String key = consumer.getKey();
        if (this.serviceProviderConsumerStore.get(key) != null) {
            this.serviceProviderConsumerStore.remove(key);
        }
    }

    public boolean isAppAssociated(String appKey) {
        return this.serviceProviderConsumerStore.get(appKey) != null;
    }

    public void associateProviderWithLink(ApplicationLink link, String key, ServiceProvider serviceProvider) {
        this.unassociateProviderWithLink(link);
        this.authenticationConfigurationManager.registerProvider(link.getId(), OAuthAuthenticationProvider.class, (Map)ImmutableMap.of((Object)CONSUMER_KEY_OUTBOUND, (Object)key, (Object)SERVICE_PROVIDER_REQUEST_TOKEN_URL, (Object)serviceProvider.getRequestTokenUri().toString(), (Object)SERVICE_PROVIDER_ACCESS_TOKEN_URL, (Object)serviceProvider.getAccessTokenUri().toString(), (Object)SERVICE_PROVIDER_AUTHORIZE_URL, (Object)serviceProvider.getAccessTokenUri().toString()));
    }

    public void unassociateProviderWithLink(ApplicationLink link) {
        if (this.authenticationConfigurationManager.isConfigured(link.getId(), OAuthAuthenticationProvider.class)) {
            this.authenticationConfigurationManager.unregisterProvider(link.getId(), OAuthAuthenticationProvider.class);
        }
    }

    public void validateOAuth2LORequest(OAuthMessage message) throws IOException, URISyntaxException, OAuthException {
        String consumerKey = message.getConsumerKey();
        Consumer consumer = this.serviceProviderConsumerStore.get(consumerKey);
        if (consumer == null) {
            Consumer self = this.consumerService.getConsumer();
            if (self.getKey().equals(consumerKey)) {
                consumer = self;
            } else {
                throw new OAuthProblemException("Unknown consumer: " + consumerKey);
            }
        }
        OAuthConsumer oauthConsumer = new OAuthConsumer(null, consumer.getKey(), null, new OAuthServiceProvider(null, null, null));
        oauthConsumer.setProperty("RSA-SHA1.PublicKey", (Object)consumer.getPublicKey().getEncoded());
        OAuthAccessor accessor = new OAuthAccessor(oauthConsumer);
        if (log.isDebugEnabled()) {
            this.printMessageToDebug(message);
        }
        this.oauthValidator.validateMessage(message, accessor);
    }

    private void printMessageToDebug(OAuthMessage message) throws IOException {
        StringBuilder sb = new StringBuilder("Validating incoming OAuth 2LO request:\n");
        sb.append("\turl: ").append(message.URL).append("\n");
        sb.append("\tmethod: ").append(message.method).append("\n");
        for (Map.Entry entry : message.getParameters()) {
            sb.append("\t").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
        }
        log.debug(sb.toString());
    }

    public String generateAuthorizationHeader(String method, ServiceProvider serviceProvider, URI url, Map<String, List<String>> originalParams) {
        Validate.notNull((Object)url);
        OAuthMessage message = this.sign(serviceProvider, method, url, originalParams);
        try {
            return message.getAuthorizationHeader(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Map.Entry<String, String>> signAsParameters(ServiceProvider serviceProvider, String method, URI url, Map<String, List<String>> originalParams) {
        OAuthMessage message = this.sign(serviceProvider, method, url, originalParams);
        if (message != null) {
            try {
                return message.getParameters();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Lists.newArrayList(Maps.transformValues(originalParams, (Function)new Function<List<String>, String>(){

            public String apply(List<String> strings) {
                return strings.get(0);
            }
        }).entrySet());
    }

    private OAuthMessage sign(ServiceProvider serviceProvider, String method, URI url, Map<String, List<String>> originalParams) {
        Validate.notNull((Object)serviceProvider);
        Validate.notNull((Object)url);
        HashMap params = Maps.newHashMap(originalParams);
        Consumer self = this.consumerService.getConsumer();
        params.put("oauth_consumer_key", Collections.singletonList(self.getKey()));
        if (log.isDebugEnabled()) {
            this.dumpParamsToSign(params);
        }
        Request oAuthRequest = new Request(Request.HttpMethod.valueOf((String)method), url, this.convertParameters(params));
        Request signedRequest = this.consumerService.sign(oAuthRequest, serviceProvider);
        return OAuthHelper.asOAuthMessage(signedRequest);
    }

    private void dumpParamsToSign(Map<String, List<String>> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("Signing outgoing with: \n");
        for (Map.Entry<String, List<String>> entry : params.entrySet()) {
            sb.append("\t").append(entry.getKey()).append(": ").append(entry.getValue().toString()).append("\n");
        }
        log.debug(sb.toString());
    }

    private List<Request.Parameter> convertParameters(Map<String, List<String>> reqParameters) {
        ArrayList<Request.Parameter> parameters = new ArrayList<Request.Parameter>();
        for (String parameterName : reqParameters.keySet()) {
            List<String> values = reqParameters.get(parameterName);
            for (String value : values) {
                parameters.add(new Request.Parameter(parameterName, value));
            }
        }
        return parameters;
    }
}

