/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.util;

import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServicePromise<T>
implements Promise<T> {
    private final SettableFuture<T> future = SettableFuture.create();
    private final Promise<T> delegate;

    public static <T> T promiseProxy(Promise<T> promise, Class<T> clazz) {
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new PromiseInvocationHandler<T>(promise)));
    }

    public ServicePromise(final BundleContext bundleContext, final Class<T> clazz) {
        ServiceTracker tracker = new ServiceTracker(bundleContext, clazz.getName(), new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                ServicePromise.this.future.set(clazz.cast(bundleContext.getService(reference)));
                return null;
            }

            public void modifiedService(ServiceReference reference, Object service) {
            }

            public void removedService(ServiceReference reference, Object service) {
            }
        });
        this.delegate = Promises.forFuture(this.future);
        tracker.open();
    }

    public T claim() {
        return (T)this.delegate.claim();
    }

    public Promise<T> done(Effect<T> tEffect) {
        return this.delegate.done(tEffect);
    }

    public Promise<T> fail(Effect<Throwable> throwableEffect) {
        return this.delegate.fail(throwableEffect);
    }

    public Promise<T> then(FutureCallback<T> tFutureCallback) {
        return this.delegate.then(tFutureCallback);
    }

    public <B> Promise<B> map(Function<? super T, ? extends B> function) {
        return this.delegate.map(function);
    }

    public <B> Promise<B> flatMap(Function<? super T, Promise<B>> promiseFunction) {
        return this.delegate.flatMap(promiseFunction);
    }

    public Promise<T> recover(Function<Throwable, ? extends T> throwableFunction) {
        return this.delegate.recover(throwableFunction);
    }

    public <B> Promise<B> fold(Function<Throwable, ? extends B> throwableFunction, Function<? super T, ? extends B> function) {
        return this.delegate.fold(throwableFunction, function);
    }

    public void addListener(Runnable runnable, Executor executor) {
        this.delegate.addListener(runnable, executor);
    }

    public boolean cancel(boolean b) {
        return this.delegate.cancel(b);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(l, timeUnit);
    }

    private static class PromiseInvocationHandler<T>
    implements InvocationHandler {
        private final Promise<T> promise;

        public PromiseInvocationHandler(Promise<T> promise) {
            this.promise = promise;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            try {
                Object instance = this.promise.claim();
                return method.invoke(instance, objects);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

