/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.license;

import com.atlassian.plugin.remotable.plugin.license.LicenseStatus;
import com.atlassian.upm.api.license.RemotePluginLicenseService;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.google.common.base.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseRetriever {
    private final RemotePluginLicenseService remotePluginLicenseService;

    @Autowired
    public LicenseRetriever(RemotePluginLicenseService remotePluginLicenseService) {
        this.remotePluginLicenseService = remotePluginLicenseService;
    }

    public Option<PluginLicense> getLicense(String pluginKey) {
        return this.remotePluginLicenseService.getRemotePluginLicense(pluginKey);
    }

    public LicenseStatus getLicenseStatus(String pluginKey) {
        return (LicenseStatus)((Object)this.getLicense(pluginKey).map((Function)new Function<PluginLicense, LicenseStatus>(){

            public LicenseStatus apply(PluginLicense input) {
                return input.isActive() ? LicenseStatus.ACTIVE : LicenseStatus.NONE;
            }
        }).getOrElse((Object)LicenseStatus.NONE));
    }
}

