/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.webhooks;

import com.atlassian.fugue.Iterables;
import com.atlassian.httpclient.api.Request;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.remotable.plugin.DefaultRemotablePluginAccessorFactory;
import com.atlassian.plugin.remotable.plugin.module.applinks.RemotePluginContainerModuleDescriptor;
import com.atlassian.webhooks.spi.plugin.RequestSigner;
import com.google.common.base.Predicate;
import java.util.Collections;
import javax.annotation.Nullable;

public class RemotePluginRequestSigner
implements RequestSigner {
    private final DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory;
    private final PluginAccessor pluginAccessor;

    public RemotePluginRequestSigner(DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory, PluginAccessor pluginAccessor) {
        this.remotablePluginAccessorFactory = remotablePluginAccessorFactory;
        this.pluginAccessor = pluginAccessor;
    }

    public void sign(String pluginKey, Request request) {
        String authValue;
        if (this.canSign(pluginKey) && (authValue = this.remotablePluginAccessorFactory.get(pluginKey).getAuthorizationGenerator().generate("POST", request.getUri(), Collections.emptyMap())) != null) {
            request.setHeader("Authorization", authValue);
        }
    }

    public boolean canSign(String pluginKey) {
        return !Iterables.findFirst((Iterable)this.pluginAccessor.getPlugin(pluginKey).getModuleDescriptors(), (Predicate)new Predicate<ModuleDescriptor<?>>(){

            public boolean apply(@Nullable ModuleDescriptor<?> input) {
                return input instanceof RemotePluginContainerModuleDescriptor;
            }
        }).isEmpty();
    }
}

