/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.util.http;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.remotable.plugin.license.LicenseRetriever;
import com.atlassian.plugin.remotable.plugin.util.LocaleHelper;
import com.atlassian.plugin.remotable.plugin.util.http.ContentRetrievalErrors;
import com.atlassian.plugin.remotable.plugin.util.http.ContentRetrievalException;
import com.atlassian.plugin.remotable.plugin.util.http.HttpContentRetriever;
import com.atlassian.plugin.remotable.spi.http.AuthorizationGenerator;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingHttpContentRetriever
implements HttpContentRetriever {
    private final Logger log = LoggerFactory.getLogger(CachingHttpContentRetriever.class);
    private final HttpClient httpClient;
    private final LicenseRetriever licenseRetriever;
    private final LocaleHelper localeHelper;

    public CachingHttpContentRetriever(PluginRetrievalService pluginRetrievalService, HttpClientFactory httpClientFactory, LicenseRetriever licenseRetriever, LocaleHelper localeHelper) {
        this.licenseRetriever = licenseRetriever;
        this.localeHelper = localeHelper;
        HttpClientOptions options = new HttpClientOptions();
        options.setIoSelectInterval(100, TimeUnit.MILLISECONDS);
        options.setThreadPrefix("content-ret");
        options.setMaxConnectionsPerHost(100);
        options.setUserAgent("Atlassian-Remotable-Plugins/" + pluginRetrievalService.getPlugin().getPluginInformation().getVersion());
        options.setConnectionTimeout(3, TimeUnit.SECONDS);
        options.setSocketTimeout(15, TimeUnit.SECONDS);
        options.setRequestTimeout(20, TimeUnit.SECONDS);
        this.httpClient = httpClientFactory.create(options);
    }

    @Override
    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpClient.flushCacheByUriPattern(urlPattern);
    }

    @Override
    public Promise<String> getAsync(AuthorizationGenerator authorizationGenerator, String remoteUsername, final URI url, Map<String, String> parameters, Map<String, String> headers, String pluginKey) {
        HashMap queryParams = Maps.newHashMap(parameters);
        queryParams.put("lic", this.licenseRetriever.getLicenseStatus(pluginKey).value());
        queryParams.put("loc", this.localeHelper.getLocaleTag());
        String urlWithParams = new UriBuilder(Uri.fromJavaUri(url)).addQueryParameters(queryParams).toString();
        String authHeaderValue = authorizationGenerator.generate("GET", url, Maps.transformValues((Map)queryParams, (Function)new Function<String, List<String>>(){

            public List<String> apply(String from) {
                return Collections.singletonList(from);
            }
        }));
        HashMap newHeaders = Maps.newHashMap(headers);
        if (authHeaderValue != null) {
            newHeaders.put("Authorization", authHeaderValue);
        }
        HashMap properties = Maps.newHashMap();
        properties.put("purpose", "content-retrieval");
        properties.put("moduleKey", pluginKey);
        this.log.info("Retrieving content from '{}' for user '{}'", new Object[]{url, remoteUsername});
        Promise promise = this.httpClient.newRequest(urlWithParams).setHeaders((Map)newHeaders).setAttributes((Map)properties).get().transform().ok((Function)new Function<Response, String>(){

            public String apply(Response input) {
                CachingHttpContentRetriever.this.log.debug("Returned ok content from: {}", (Object)url);
                return input.getEntity();
            }
        }).forbidden((Function)new Function<Response, String>(){

            public String apply(Response input) {
                CachingHttpContentRetriever.this.log.debug("Returned forbidden: {}", (Object)url);
                throw new ContentRetrievalException("Operation not authorized!");
            }
        }).others((Function)new Function<Response, String>(){

            public String apply(Response input) {
                CachingHttpContentRetriever.this.log.debug("Returned others: {}", (Object)url);
                if ("application/json".equalsIgnoreCase(input.getContentType())) {
                    throw new ContentRetrievalException(ContentRetrievalErrors.fromJson(input.getEntity()));
                }
                CachingHttpContentRetriever.this.log.debug("An unknown error occurred retrieving HTTP content. Status is {}, body content is:\n{}\n", (Object)input.getStatusCode(), (Object)input.getEntity());
                throw new ContentRetrievalException("An unknown error occurred!");
            }
        }).fail((Function)new Function<Throwable, String>(){

            public String apply(Throwable input) {
                if (!(input instanceof ContentRetrievalException)) {
                    CachingHttpContentRetriever.this.log.debug("Return failed: {}", (Object)url);
                    CachingHttpContentRetriever.this.log.debug(input.getMessage(), input);
                    throw new ContentRetrievalException(input);
                }
                throw (ContentRetrievalException)input;
            }
        }).toPromise();
        if (promise.isDone()) {
            this.log.debug("Request {} retrieved from the cache", (Object)url);
        } else {
            this.log.debug("Request {} isn't in the cache, retrieving...", (Object)url);
        }
        return promise;
    }
}

