/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.confluence;

import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.pages.thumbnail.Dimensions;
import com.atlassian.confluence.plugin.descriptor.MacroMetadataParser;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.DefaultRemotablePluginAccessorFactory;
import com.atlassian.plugin.remotable.plugin.PermissionManager;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DescriptorToRegister;
import com.atlassian.plugin.remotable.plugin.module.IFrameParamsImpl;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.plugin.module.WebItemCreator;
import com.atlassian.plugin.remotable.plugin.module.confluence.FixedXhtmlMacroModuleDescriptor;
import com.atlassian.plugin.remotable.plugin.module.confluence.ImagePlaceholderMacroWrapper;
import com.atlassian.plugin.remotable.plugin.module.confluence.RemoteMacro;
import com.atlassian.plugin.remotable.plugin.module.confluence.RemoteMacroInfo;
import com.atlassian.plugin.remotable.plugin.module.confluence.StorageFormatMacro;
import com.atlassian.plugin.remotable.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.remotable.plugin.module.page.IFramePageServlet;
import com.atlassian.plugin.remotable.plugin.module.page.PageInfo;
import com.atlassian.plugin.remotable.plugin.module.util.redirect.RedirectServlet;
import com.atlassian.plugin.remotable.plugin.util.EncodingUtils;
import com.atlassian.plugin.remotable.plugin.util.OsgiServiceUtils;
import com.atlassian.plugin.remotable.plugin.util.contextparameter.ContextParameterParser;
import com.atlassian.plugin.remotable.plugin.util.contextparameter.RequestContextParameterFactory;
import com.atlassian.plugin.remotable.plugin.util.node.Dom4jNode;
import com.atlassian.plugin.remotable.plugin.util.node.ElementSetWriter;
import com.atlassian.plugin.remotable.plugin.util.node.Node;
import com.atlassian.plugin.remotable.plugin.util.node.SingleElementWriter;
import com.atlassian.plugin.remotable.spi.RemotablePluginAccessor;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletModuleDescriptor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.conditions.AlwaysDisplayCondition;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.osgi.framework.BundleContext;

public class MacroModuleDescriptorCreator {
    private final SystemInformationService systemInformationService;
    private final MacroMetadataParser macroMetadataParser;
    private final DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory;
    private final HostContainer hostContainer;
    private final WebItemCreator webItemCreator;
    private final ContextParameterParser contextParameterParser;
    private final IFrameRendererImpl iFrameRenderer;
    private final UserManager userManager;
    private final PermissionManager permissionManager;
    private final BundleContext bundleContext;

    public MacroModuleDescriptorCreator(SystemInformationService systemInformationService, DefaultRemotablePluginAccessorFactory remotablePluginAccessorFactory, HostContainer hostContainer, WebItemCreator webItemCreator, ContextParameterParser contextParameterParser, IFrameRendererImpl iFrameRenderer, UserManager userManager, PermissionManager permissionManager, BundleContext bundleContext) {
        this.systemInformationService = systemInformationService;
        this.remotablePluginAccessorFactory = remotablePluginAccessorFactory;
        this.hostContainer = hostContainer;
        this.webItemCreator = webItemCreator;
        this.contextParameterParser = contextParameterParser;
        this.iFrameRenderer = iFrameRenderer;
        this.userManager = userManager;
        this.permissionManager = permissionManager;
        this.bundleContext = bundleContext;
        this.macroMetadataParser = (MacroMetadataParser)ComponentLocator.getComponent(MacroMetadataParser.class);
    }

    public Builder newBuilder() {
        return new Builder();
    }

    public class Builder {
        private MacroFactory macroFactory;
        private final WebItemCreator.Builder webItemCreatorBuilder;

        public Builder() {
            this.webItemCreatorBuilder = MacroModuleDescriptorCreator.this.webItemCreator.newBuilder();
        }

        public Builder setMacroFactory(MacroFactory macroFactory) {
            this.macroFactory = macroFactory;
            return this;
        }

        public Iterable<DescriptorToRegister> build(Plugin plugin, Node entity) {
            boolean hasCustomEditor;
            URI icon;
            Element config = DocumentHelper.createElement((String)"macro");
            ((ElementSetWriter)((ElementSetWriter)new SingleElementWriter(entity, config).copyDescription().copyIfExists("body-type").copyIfExists("output-type").copyNodes("alias").copyText()).done().copyNodes("category").copyIfExists("name")).done();
            RemotablePluginAccessor remotablePluginAccessor = MacroModuleDescriptorCreator.this.remotablePluginAccessorFactory.get(plugin.getKey());
            String key = entity.get("key").asString();
            String macroKey = "macro-" + key;
            config.addAttribute("key", macroKey);
            String name = entity.get("title").asString(entity.get("name").asString(key));
            config.addAttribute("name", key);
            config.addAttribute("i18n-name-key", plugin.getKey() + "." + key + ".label");
            config.addAttribute("system", "true");
            config.addAttribute("class", StorageFormatMacro.class.getName());
            if (config.element("parameters") == null) {
                config.addElement("parameters");
            }
            if ((icon = Dom4jUtils.getOptionalUriAttribute((Element)config, (String)"icon-url")) != null) {
                String baseUrl = MacroModuleDescriptorCreator.this.systemInformationService.getConfluenceInfo().getBaseUrl();
                config.addAttribute("icon", baseUrl + RedirectServlet.getPermanentRedirectUrl(plugin.getKey(), icon));
            }
            HashSet<DescriptorToRegister> descriptors = new HashSet<DescriptorToRegister>();
            ModuleDescriptor descriptor = this.createXhtmlMacroModuleDescriptor(plugin, entity);
            descriptor.init(plugin, config);
            descriptors.add(new DescriptorToRegister(descriptor, this.getI18nMessages(plugin.getKey(), entity)));
            boolean isFeaturedMacro = entity.get("featured").asBoolean(false);
            if (isFeaturedMacro) {
                config.addAttribute("featured", "true");
                descriptors.add(this.createFeaturedMacroDescriptor(plugin, key, entity));
                if (icon != null) {
                    descriptors.add(this.createFeaturedIconWebResource(plugin, remotablePluginAccessor, key, icon));
                }
            }
            if (hasCustomEditor = entity.get("macro-editor").exists()) {
                descriptors.addAll(this.createMacroEditorDescriptors(plugin, entity, key, name));
            }
            return ImmutableSet.copyOf(descriptors);
        }

        private Properties getI18nMessages(String pluginKey, Node element) {
            Properties i18n = new Properties();
            String macroKey = element.get("key").asString();
            if (element.get("parameters").exists()) {
                for (Node parameter : element.get("parameters").getChildren("parameter")) {
                    String description;
                    String paramTitle = parameter.get("title").asString(null);
                    String paramName = parameter.get("name").asString();
                    if (paramTitle != null) {
                        i18n.put(pluginKey + "." + macroKey + ".param." + paramName + ".label", paramTitle);
                    }
                    if (StringUtils.isBlank((String)(description = parameter.get("description").asString(null)))) continue;
                    i18n.put(pluginKey + "." + macroKey + ".param." + paramName + ".desc", description);
                }
            }
            String macroName = element.get("title").asString(element.get("name").asString(macroKey));
            i18n.put(pluginKey + "." + macroKey + ".label", macroName);
            if (element.get("description").asString(null) != null) {
                i18n.put(pluginKey + "." + macroKey + ".desc", element.get("description").asString());
            }
            if (!MacroModuleDescriptorCreator.this.permissionManager.hasPermission(pluginKey, "generate_any_html")) {
                for (String propName : i18n.stringPropertyNames()) {
                    i18n.put(propName, EncodingUtils.escapeAll(i18n.getProperty(propName)));
                }
            }
            return i18n;
        }

        private Collection<DescriptorToRegister> createMacroEditorDescriptors(Plugin plugin, Node config, String macroKey, String macroName) {
            Node macroEditor = config.get("macro-editor");
            URI originalUrl = macroEditor.get("url").asURI();
            URI localUrl = URI.create("/remotable-plugins/" + plugin.getKey() + "/" + macroKey + "-editor");
            ServletModuleDescriptor iFrameServlet = this.createMacroEditorServletDescriptor(plugin, macroEditor, macroKey, originalUrl, localUrl);
            ModuleDescriptor jsDescriptor = this.createCustomEditorWebResource(plugin, macroEditor, macroKey, macroName, localUrl);
            return Lists.newArrayList((Object[])new DescriptorToRegister[]{new DescriptorToRegister(jsDescriptor), new DescriptorToRegister((ModuleDescriptor)iFrameServlet)});
        }

        private DescriptorToRegister createFeaturedMacroDescriptor(Plugin plugin, String macroKey, Node macroConfig) {
            String name = macroConfig.get("name").asString();
            Element webItem = DocumentHelper.createDocument().addElement("web-item").addAttribute("name", name).addAttribute("key", "editor-featured-macro-" + macroKey).addAttribute("section", "system.editor.featured.macros.default").addElement("label").addText(name).getParent().addElement("link").addAttribute("linkId", macroKey).getParent();
            if (macroConfig.get("icon-url").exists()) {
                webItem.addAttribute("icon-url", macroConfig.get("icon-url").asString());
            }
            return new DescriptorToRegister((ModuleDescriptor)this.webItemCreatorBuilder.build(plugin, macroKey, null, new Dom4jNode(webItem)));
        }

        private ServletModuleDescriptor createMacroEditorServletDescriptor(final Plugin plugin, Node e, final String key, final URI path, URI localUrl) {
            final String moduleKey = "servlet-" + key;
            Element config = DocumentHelper.createElement((String)"servlet").addAttribute("key", moduleKey).addAttribute("system", "true").addAttribute("class", IFramePageServlet.class.getName());
            config.addElement("url-pattern").setText(localUrl + "");
            config.addElement("url-pattern").setText(localUrl + "/*");
            final IFrameParamsImpl params = new IFrameParamsImpl(e);
            ServletModuleDescriptor descriptor = new ServletModuleDescriptor(new ModuleFactory(){

                public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
                    PageInfo pageInfo = new PageInfo("", "-dialog", key, (Condition)new AlwaysDisplayCondition(), (Map<String, String>)ImmutableMap.of());
                    return (T)((Object)new IFramePageServlet(pageInfo, MacroModuleDescriptorCreator.this.iFrameRenderer, new IFrameContextImpl(plugin.getKey(), path, moduleKey, params), MacroModuleDescriptorCreator.this.userManager));
                }
            }, OsgiServiceUtils.getService(MacroModuleDescriptorCreator.this.bundleContext, ServletModuleManager.class));
            descriptor.init(plugin, config);
            return descriptor;
        }

        private ModuleDescriptor createCustomEditorWebResource(Plugin plugin, Node macroEditorConfig, String macroKey, String macroName, URI customEditorLocalUrl) {
            Element webResource = DocumentHelper.createDocument().addElement("web-resource").addAttribute("key", macroKey + "-macro-editor-resources");
            webResource.addElement("resource").addAttribute("type", "download").addAttribute("name", "macro-override.js").addAttribute("location", "js/confluence/macro/macro-override.js");
            webResource.addElement("dependency").setText("confluence.web.resources:ajs");
            webResource.addElement("context").setText("editor");
            Element transformation = webResource.addElement("transformation").addAttribute("extension", "js");
            transformation.addElement("transformer").addAttribute("key", "confluence-macroVariableTransformer").addElement("var").addAttribute("name", "MACRONAME").addAttribute("value", macroKey).getParent().addElement("var").addAttribute("name", "URL").addAttribute("value", "/plugins/servlet" + customEditorLocalUrl).getParent().addElement("var").addAttribute("name", "WIDTH").addAttribute("value", macroEditorConfig.get("width").asString("")).getParent().addElement("var").addAttribute("name", "HEIGHT").addAttribute("value", macroEditorConfig.get("height").asString("")).getParent().addElement("var").addAttribute("name", "EDIT_TITLE").addAttribute("value", macroName).addAttribute("i18n-key", "macro.browser.edit.macro.title").getParent().addElement("var").addAttribute("name", "INSERT_TITLE").addAttribute("value", macroName).addAttribute("i18n-key", "macro.browser.insert.macro.title").getParent();
            WebResourceModuleDescriptor jsDescriptor = new WebResourceModuleDescriptor(MacroModuleDescriptorCreator.this.hostContainer);
            jsDescriptor.init(plugin, webResource);
            return jsDescriptor;
        }

        private DescriptorToRegister createFeaturedIconWebResource(Plugin plugin, RemotablePluginAccessor remotablePluginAccessor, String macroKey, URI iconUrl) {
            Element webResource = DocumentHelper.createDocument().addElement("web-resource").addAttribute("key", macroKey + "-featured-macro-resources");
            webResource.addElement("resource").addAttribute("type", "download").addAttribute("name", macroKey + "-icon.css").addAttribute("location", "css/confluence/macro/featured-macro-icon.css");
            webResource.addElement("context").setText("editor");
            Element transformation = webResource.addElement("transformation").addAttribute("extension", "css");
            transformation.addElement("transformer").addAttribute("key", "confluence-macroVariableTransformer").addElement("var").addAttribute("name", "KEY").addAttribute("value", macroKey).getParent().addElement("var").addAttribute("name", "ICON_URL").addAttribute("value", remotablePluginAccessor.getDisplayUrl() + iconUrl.toString()).getParent();
            WebResourceModuleDescriptor jsDescriptor = new WebResourceModuleDescriptor(MacroModuleDescriptorCreator.this.hostContainer);
            jsDescriptor.init(plugin, webResource);
            return new DescriptorToRegister((ModuleDescriptor)jsDescriptor);
        }

        private ModuleDescriptor createXhtmlMacroModuleDescriptor(final Plugin plugin, final Node originalEntity) {
            final Macro.BodyType bodyType = this.parseBodyType(originalEntity);
            final Macro.OutputType outputType = this.parseOutputType(originalEntity);
            final URI url = originalEntity.get("url").asURI();
            final RequestContextParameterFactory requestContextParameterFactory = MacroModuleDescriptorCreator.this.contextParameterParser.parseContextParameters(originalEntity);
            final ImagePlaceholderConfig placeholder = this.parseImagePlaceholder(originalEntity);
            ModuleFactory factory = new ModuleFactory(){

                public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
                    RemoteMacroInfo macroInfo = new RemoteMacroInfo(originalEntity, plugin.getKey(), bodyType, outputType, requestContextParameterFactory, url);
                    RemoteMacro macro = Builder.this.macroFactory.create(macroInfo);
                    if (placeholder != null && Macro.BodyType.NONE.equals((Object)bodyType)) {
                        return (T)new ImagePlaceholderMacroWrapper(macro, placeholder.applyChrome, placeholder.getDimensions(), placeholder.imageUrl, plugin.getKey(), MacroModuleDescriptorCreator.this.userManager);
                    }
                    return (T)macro;
                }
            };
            return new FixedXhtmlMacroModuleDescriptor(factory, MacroModuleDescriptorCreator.this.macroMetadataParser);
        }

        private Macro.OutputType parseOutputType(Node entity) {
            String value = entity.get("output-type").asString("block");
            return Macro.OutputType.valueOf((String)value.toUpperCase(Locale.US));
        }

        private Macro.BodyType parseBodyType(Node entity) {
            Macro.BodyType bodyType;
            String bodyTypeValue = entity.get("body-type").asString("none");
            if ("rich-text".equals(bodyTypeValue)) {
                bodyType = Macro.BodyType.RICH_TEXT;
            } else if ("plain-text".equals(bodyTypeValue)) {
                bodyType = Macro.BodyType.PLAIN_TEXT;
            } else if ("none".equals(bodyTypeValue)) {
                bodyType = Macro.BodyType.NONE;
            } else {
                throw new IllegalArgumentException("Invalid body type '" + bodyTypeValue);
            }
            return bodyType;
        }

        private ImagePlaceholderConfig parseImagePlaceholder(Node entity) {
            Node placeholder = entity.get("image-placeholder");
            if (!placeholder.exists()) {
                return null;
            }
            URI url = placeholder.get("url").asURI();
            String width = placeholder.get("width").asString(null);
            String height = placeholder.get("height").asString(null);
            String applyChrome = placeholder.get("apply-chrome").asString(null);
            return new ImagePlaceholderConfig(url, width == null ? null : Integer.valueOf(Integer.parseInt(width)), height == null ? null : Integer.valueOf(Integer.parseInt(height)), applyChrome == null || Boolean.parseBoolean(applyChrome));
        }

        private class ImagePlaceholderConfig {
            URI imageUrl;
            Integer width;
            Integer height;
            boolean applyChrome;

            private ImagePlaceholderConfig(URI imageUrl, Integer width, Integer height, boolean applyChrome) {
                this.imageUrl = imageUrl;
                this.width = width;
                this.height = height;
                this.applyChrome = applyChrome;
            }

            public Dimensions getDimensions() {
                if (this.height != null && this.width != null) {
                    return new Dimensions(this.width.intValue(), this.height.intValue());
                }
                return null;
            }
        }
    }

    public static interface MacroFactory {
        public RemoteMacro create(RemoteMacroInfo var1);
    }
}

