/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.util.node;

import com.atlassian.plugin.remotable.plugin.util.node.ElementSetWriter;
import com.atlassian.plugin.remotable.plugin.util.node.ElementWriter;
import com.atlassian.plugin.remotable.plugin.util.node.MultiElementWriter;
import com.atlassian.plugin.remotable.plugin.util.node.Node;
import org.dom4j.Element;

public class SingleElementWriter
implements ElementWriter<SingleElementWriter> {
    private final Node source;
    private final Element target;

    public SingleElementWriter(Node source, Element target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public SingleElementWriter copyText() {
        this.target.addText(this.source.asString(""));
        return this;
    }

    @Override
    public SingleElementWriter copyDescription() {
        Node node = this.source.get("description");
        if (node.exists()) {
            Element desc = this.target.addElement("description");
            new SingleElementWriter(node, desc).copyIfExists("key").copyText();
        }
        return this;
    }

    @Override
    public SingleElementWriter copy(String propertyName) {
        this.target.addAttribute(propertyName, this.source.get(propertyName).asString());
        return this;
    }

    @Override
    public SingleElementWriter copyIfExists(String propertyName) {
        Node node = this.source.get(propertyName);
        if (node.exists()) {
            this.target.addAttribute(propertyName, node.asString());
        }
        return this;
    }

    public ElementSetWriter copyNodes(String propertyName) {
        return new MultiElementWriter(this.source.getChildren(propertyName), this.target, this);
    }
}

