/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.jira.projecttab;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptorImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DescriptorToRegister;
import com.atlassian.plugin.remotable.plugin.integration.plugins.DynamicDescriptorRegistration;
import com.atlassian.plugin.remotable.plugin.module.ConditionProcessor;
import com.atlassian.plugin.remotable.plugin.module.ContainingRemoteCondition;
import com.atlassian.plugin.remotable.plugin.module.IFrameParamsImpl;
import com.atlassian.plugin.remotable.plugin.module.IFrameRendererImpl;
import com.atlassian.plugin.remotable.plugin.module.jira.projecttab.IFrameProjectTab;
import com.atlassian.plugin.remotable.plugin.module.page.IFrameContextImpl;
import com.atlassian.plugin.remotable.plugin.util.node.Dom4jNode;
import com.atlassian.plugin.remotable.plugin.util.node.Node;
import com.atlassian.plugin.remotable.spi.module.IFrameParams;
import com.atlassian.plugin.web.Condition;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import java.net.URI;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class ProjectTabPageModuleDescriptor
extends AbstractModuleDescriptor<Void> {
    private final IFrameRendererImpl iFrameRenderer;
    private final DynamicDescriptorRegistration dynamicDescriptorRegistration;
    private final ConditionProcessor conditionProcessor;
    private Node descriptor;
    private URI url;
    private DynamicDescriptorRegistration.Registration registration;

    public ProjectTabPageModuleDescriptor(ModuleFactory moduleFactory, IFrameRendererImpl iFrameRenderer, DynamicDescriptorRegistration dynamicDescriptorRegistration, ConditionProcessor conditionProcessor) {
        super(moduleFactory);
        this.iFrameRenderer = (IFrameRendererImpl)Preconditions.checkNotNull((Object)iFrameRenderer);
        this.dynamicDescriptorRegistration = (DynamicDescriptorRegistration)Preconditions.checkNotNull((Object)dynamicDescriptorRegistration);
        this.conditionProcessor = (ConditionProcessor)Preconditions.checkNotNull((Object)conditionProcessor);
    }

    public Void getModule() {
        return null;
    }

    public void init(@NotNull Plugin plugin, @NotNull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.descriptor = new Dom4jNode(element);
        this.url = this.descriptor.get("url").asURI();
    }

    public void enabled() {
        super.enabled();
        String panelName = this.descriptor.get("name").asString();
        Element desc = DocumentHelper.createElement((String)"project-tab-panel");
        String moduleKey = "project-tab-" + this.descriptor.get("key").asString();
        Condition condition = this.conditionProcessor.process(this.descriptor, desc, this.getPluginKey(), "#" + moduleKey + "-remote-condition-panel");
        if (condition instanceof ContainingRemoteCondition) {
            moduleKey = moduleKey + "-remote-condition";
        }
        desc.addAttribute("key", moduleKey);
        desc.addElement("label").setText(panelName);
        desc.addAttribute("class", IFrameProjectTab.class.getName());
        ProjectTabPanelModuleDescriptor moduleDescriptor = this.createDescriptor(moduleKey, desc, new IFrameParamsImpl(this.descriptor), condition);
        this.registration = this.dynamicDescriptorRegistration.registerDescriptors(this.getPlugin(), new DescriptorToRegister((ModuleDescriptor)moduleDescriptor));
    }

    public void disabled() {
        super.disabled();
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    private ProjectTabPanelModuleDescriptor createDescriptor(final String key, Element desc, final IFrameParams iFrameParams, final Condition condition) {
        try {
            desc.addAttribute("system", "true");
            ProjectTabPanelModuleDescriptorImpl descriptor = new ProjectTabPanelModuleDescriptorImpl((JiraAuthenticationContext)ComponentManager.getComponent(JiraAuthenticationContext.class), new ModuleFactory(){

                public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
                    return (T)new IFrameProjectTab(new IFrameContextImpl(ProjectTabPageModuleDescriptor.this.getPluginKey(), ProjectTabPageModuleDescriptor.this.url, key, iFrameParams), ProjectTabPageModuleDescriptor.this.iFrameRenderer, condition);
                }
            });
            descriptor.init(this.getPlugin(), desc);
            return descriptor;
        }
        catch (Exception ex) {
            throw new PluginParseException((Throwable)ex);
        }
    }
}

