/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.host.common.util.BundleLocator;
import com.atlassian.plugin.remotable.host.common.util.RemotablePluginManifestReader;
import com.atlassian.plugin.remotable.spi.host.HostProperties;
import com.atlassian.plugin.remotable.spi.permission.PermissionsReader;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.plugin.remotable.spi.util.XmlUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.osgi.framework.Bundle;

public final class DescriptorPermissionsReader
implements PermissionsReader {
    private final Cache<Plugin, Set<String>> permissionsCache;
    private final String productKey;

    public DescriptorPermissionsReader(HostProperties hostProperties, final BundleLocator bundleLocator) {
        this.productKey = hostProperties.getKey();
        this.permissionsCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Plugin, Set<String>>(){

            public Set<String> load(Plugin plugin) throws Exception {
                return DescriptorPermissionsReader.this.read(bundleLocator.getBundle(plugin.getKey()), DescriptorPermissionsReader.this.productKey);
            }
        });
    }

    public Set<String> getPermissionsForPlugin(Plugin plugin) {
        try {
            return (Set)this.permissionsCache.get((Object)plugin);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<String> readPermissionsFromDescriptor(Document document, InstallationMode installationMode) {
        return this.read(document, this.productKey, installationMode);
    }

    private Set<String> read(Bundle bundle, String productKey) {
        try {
            URL sourceUrl = bundle.getEntry("atlassian-plugin.xml");
            Document source = XmlUtils.createSecureSaxReader().read(sourceUrl);
            return this.read(source, productKey, RemotablePluginManifestReader.isRemotePlugin(bundle) ? InstallationMode.REMOTE : InstallationMode.LOCAL);
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("Unable to parse permissions from plugin descriptor", e);
        }
    }

    private Set<String> read(Document source, String productKey, InstallationMode installationMode) {
        String scopes;
        HashSet permissions = Sets.newHashSet();
        Element permissionsElement = source.getRootElement().element("plugin-info").element("permissions");
        if (permissionsElement != null) {
            for (Element e : permissionsElement.elements()) {
                String targetInstallationMode;
                String application = Dom4jUtils.getOptionalAttribute((Element)e, (String)"application", (Object)productKey);
                if (!productKey.equals(application) || (targetInstallationMode = Dom4jUtils.getOptionalAttribute((Element)e, (String)"installation-mode", null)) != null && !targetInstallationMode.equalsIgnoreCase(installationMode.getKey())) continue;
                permissions.add(e.getTextTrim());
            }
        }
        if ((scopes = StringUtils.join((Collection)permissions, (String)",")).length() > 220) {
            throw new PluginParseException("Cannot install remote plugin that contains too many permissions.");
        }
        return permissions;
    }
}

