/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http;

import com.atlassian.plugin.remotable.api.service.RequestContext;
import com.atlassian.plugin.remotable.api.service.SignedRequestHandler;
import javax.servlet.http.HttpServletRequest;

public final class DefaultRequestContext
implements RequestContext {
    private static final ThreadLocal<RequestData> requestContextHolder = new ThreadLocal();
    private static final RequestData EMPTY_DATA = new RequestData(null, null, null);
    private final SignedRequestHandler signedRequestHandler;

    public DefaultRequestContext(SignedRequestHandler signedRequestHandler) {
        this.signedRequestHandler = signedRequestHandler;
    }

    public String getClientKey() {
        return DefaultRequestContext.getRequestData().getClientKey();
    }

    public void setClientKey(String clientKey) {
        RequestData data = DefaultRequestContext.getRequestData();
        DefaultRequestContext.setRequestData(new RequestData(data.getRequest(), clientKey, data.getUserId()));
    }

    static RequestData getRequestData() {
        RequestData data = requestContextHolder.get();
        return data != null ? data : EMPTY_DATA;
    }

    static void setRequestData(RequestData data) {
        if (data == EMPTY_DATA) {
            DefaultRequestContext.clear();
        } else {
            requestContextHolder.set(data);
        }
    }

    public String getUserId() {
        return DefaultRequestContext.getRequestData().getUserId();
    }

    public void setUserId(String userId) {
        RequestData data = DefaultRequestContext.getRequestData();
        DefaultRequestContext.setRequestData(new RequestData(data.getRequest(), data.getClientKey(), userId));
    }

    public String getHostBaseUrl() {
        String clientKey = this.getClientKey();
        return clientKey != null ? this.signedRequestHandler.getHostBaseUrl(clientKey) : null;
    }

    public HttpServletRequest getRequest() {
        return requestContextHolder.get().getRequest();
    }

    public void setRequest(HttpServletRequest request) {
        RequestData data = DefaultRequestContext.getRequestData();
        DefaultRequestContext.setRequestData(new RequestData(request, data.getClientKey(), data.getUserId()));
    }

    public static void clear() {
        requestContextHolder.remove();
    }

    static final class RequestData {
        private final String clientKey;
        private final String userId;
        private final HttpServletRequest request;

        private RequestData(HttpServletRequest request, String clientKey, String userId) {
            this.request = request;
            this.clientKey = clientKey;
            this.userId = userId;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public String getClientKey() {
            return this.clientKey;
        }

        public String getUserId() {
            return this.userId;
        }
    }
}

