/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasXPath
extends TypeSafeDiagnosingMatcher<Node> {
    private final Matcher<? super String> valueMatcher;
    private final XPathExpression compiledXPath;
    private final String xpathString;
    private final QName evaluationMode;

    public HasXPath(String xPathExpression, Matcher<? super String> valueMatcher) {
        this(xPathExpression, null, valueMatcher);
    }

    public HasXPath(String xPathExpression, NamespaceContext namespaceContext, Matcher<? super String> valueMatcher) {
        this(xPathExpression, namespaceContext, valueMatcher, XPathConstants.STRING);
    }

    private HasXPath(String xPathExpression, NamespaceContext namespaceContext, Matcher<? super String> valueMatcher, QName mode) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            if (namespaceContext != null) {
                xPath.setNamespaceContext(namespaceContext);
            }
            this.compiledXPath = xPath.compile(xPathExpression);
            this.xpathString = xPathExpression;
            this.valueMatcher = valueMatcher;
            this.evaluationMode = mode;
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Invalid XPath : " + xPathExpression, e);
        }
    }

    @Override
    public boolean matchesSafely(Node item, Description mismatchDescription) {
        try {
            return this.matchesResult(this.compiledXPath.evaluate(item, this.evaluationMode), mismatchDescription);
        }
        catch (XPathExpressionException e) {
            return false;
        }
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("an XML document with XPath ").appendText(this.xpathString);
        if (this.valueMatcher != null) {
            description.appendText(" ").appendDescriptionOf(this.valueMatcher);
        }
    }

    private boolean matchesResult(Object result, Description mismatchDescription) {
        if (result == null) {
            mismatchDescription.appendText("xpath returned no results.");
            return false;
        }
        if (this.valueMatcher == null) {
            return true;
        }
        boolean valueMatched = this.valueMatcher.matches(result);
        if (!valueMatched) {
            mismatchDescription.appendText("xpath result ");
            this.valueMatcher.describeMismatch(result, mismatchDescription);
        }
        return valueMatched;
    }

    @Factory
    public static Matcher<Node> hasXPath(String xPath, Matcher<? super String> valueMatcher) {
        return HasXPath.hasXPath(xPath, null, valueMatcher);
    }

    @Factory
    public static Matcher<Node> hasXPath(String xPath, NamespaceContext namespaceContext, Matcher<? super String> valueMatcher) {
        return new HasXPath(xPath, namespaceContext, valueMatcher, XPathConstants.STRING);
    }

    @Factory
    public static Matcher<Node> hasXPath(String xPath) {
        return HasXPath.hasXPath(xPath, (NamespaceContext)null);
    }

    @Factory
    public static Matcher<Node> hasXPath(String xPath, NamespaceContext namespaceContext) {
        return new HasXPath(xPath, namespaceContext, null, XPathConstants.NODE);
    }
}

