/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.installer;

import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.remotable.api.annotation.ComponentImport;
import com.atlassian.plugin.remotable.plugin.loader.StartableForPlugins;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DependencyRefresher {
    private static final Logger log = LoggerFactory.getLogger(DependencyRefresher.class);

    @Autowired
    public DependencyRefresher(StartableForPlugins startableForPlugins, PluginRetrievalService pluginRetrievalService, final BundleContext context) {
        startableForPlugins.register(pluginRetrievalService.getPlugin().getKey(), new Runnable(){

            @Override
            public void run() {
                ServiceReference ref = context.getServiceReference(PackageAdmin.class.getName());
                PackageAdmin packageAdmin = (PackageAdmin)context.getService(ref);
                ServiceReference ref2 = context.getServiceReference(PluginController.class.getName());
                PluginController pluginController = (PluginController)context.getService(ref2);
                Set bundlesUsingOldApi = DependencyRefresher.this.getRequiredPluginsFromExports(context, packageAdmin);
                if (!bundlesUsingOldApi.isEmpty()) {
                    log.info("Detected bundles using old api versions, refreshing " + Iterables.transform((Iterable)bundlesUsingOldApi, (Function)new Function<Bundle, String>(){

                        public String apply(@Nullable Bundle input) {
                            return input.getBundleId() + ": " + input.getSymbolicName() + " - " + input.getVersion();
                        }
                    }).toString());
                    Iterable pluginKeys = Iterables.transform((Iterable)Iterables.filter((Iterable)bundlesUsingOldApi, (Predicate)new Predicate<Bundle>(){

                        public boolean apply(@Nullable Bundle input) {
                            return OsgiHeaderUtil.getPluginKey((Bundle)input) != null;
                        }
                    }), (Function)new Function<Bundle, String>(){

                        public String apply(@Nullable Bundle input) {
                            return OsgiHeaderUtil.getPluginKey((Bundle)input);
                        }
                    });
                    for (String pluginKey : pluginKeys) {
                        pluginController.disablePluginWithoutPersisting(pluginKey);
                    }
                    packageAdmin.refreshPackages(bundlesUsingOldApi.toArray(new Bundle[bundlesUsingOldApi.size()]));
                    pluginController.enablePlugins(Lists.newArrayList((Iterable)pluginKeys).toArray(new String[0]));
                }
            }
        });
    }

    private Set<Bundle> getRequiredPluginsFromExports(BundleContext bundleContext, PackageAdmin packageAdmin) {
        HashSet bundlesUsingOldApi = Sets.newHashSet();
        Version latestApiVersion = packageAdmin.getExportedPackage(ComponentImport.class.getPackage().getName()).getVersion();
        Set<String> imports = this.getApiAndSpiImports(bundleContext, packageAdmin);
        for (String imp : imports) {
            ExportedPackage[] exports = packageAdmin.getExportedPackages(imp);
            if (exports == null) continue;
            block1: for (ExportedPackage export : exports) {
                Bundle[] importingBundles;
                if (export.getVersion().equals((Object)latestApiVersion) || (importingBundles = export.getImportingBundles()) == null) continue;
                for (Bundle importingBundle : importingBundles) {
                    if (bundleContext.getBundle().getSymbolicName().equals(importingBundle.getSymbolicName()) || importingBundle.getSymbolicName().startsWith("com.atlassian.plugins.remotable-plugins-") || importingBundle.getSymbolicName().equals("remotable.plugins.i18n")) continue;
                    bundlesUsingOldApi.add(importingBundle);
                    continue block1;
                }
            }
        }
        return bundlesUsingOldApi;
    }

    private Set<String> getApiAndSpiImports(BundleContext bundleContext, PackageAdmin packageAdmin) {
        HashSet<String> imports = new HashSet<String>();
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().equals("com.atlassian.plugins.remotable-plugins-api") && !bundle.getSymbolicName().equals("com.atlassian.plugins.remotable-plugins-spi")) continue;
            imports.addAll(OsgiHeaderUtil.parseHeader((String)((String)bundle.getHeaders().get("Export-Package"))).keySet());
        }
        return imports;
    }
}

