/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.module.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.plugin.remotable.plugin.util.contextparameter.RequestContextParameterFactory;
import com.atlassian.plugin.remotable.plugin.util.contextparameter.RequestContextParameters;
import com.atlassian.plugin.remotable.spi.RemotablePluginAccessor;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class MacroInstance {
    final ConversionContext conversionContext;
    final URI path;
    final RemotablePluginAccessor remotablePluginAccessor;
    final String body;
    final Map<String, String> parameters;
    final Map<String, String> allContextParameters;
    final RequestContextParameterFactory requestContextParameterFactory;

    public MacroInstance(ConversionContext conversionContext, URI path, String body, Map<String, String> parameters, RequestContextParameterFactory requestContextParameterFactory, RemotablePluginAccessor remotablePluginAccessor) {
        this.conversionContext = conversionContext;
        this.path = path;
        this.body = body;
        this.parameters = parameters;
        this.remotablePluginAccessor = remotablePluginAccessor;
        this.allContextParameters = this.getAllContextParameters();
        this.requestContextParameterFactory = requestContextParameterFactory;
    }

    public ConversionContext getConversionContext() {
        return this.conversionContext;
    }

    public ContentEntityObject getEntity() {
        return this.conversionContext.getEntity();
    }

    public URI getPath() {
        return this.path;
    }

    public RemotablePluginAccessor getRemotablePluginAccessor() {
        return this.remotablePluginAccessor;
    }

    public Map<String, String> getUrlParameters(String userId) {
        RequestContextParameters requestContextParameters = this.createRequestContextParameters(userId);
        HashMap params = Maps.newHashMap(requestContextParameters.getQueryParameters());
        params.put("body", this.body);
        params.put("key", this.getHashKey());
        params.putAll(this.parameters);
        params.remove(": = | RAW | = :");
        return params;
    }

    private Map<String, String> getAllContextParameters() {
        HashMap params = Maps.newHashMap();
        params.put("output_type", this.conversionContext.getOutputType());
        if (this.conversionContext.getEntity() != null) {
            String pageId = this.conversionContext.getEntity().getIdAsString();
            String pageTitle = this.conversionContext.getEntity().getTitle();
            pageTitle = pageTitle != null ? pageTitle : "";
            params.put("page_id", pageId);
            params.put("page_type", this.conversionContext.getEntity().getType());
            params.put("page_title", pageTitle);
        } else {
            params.put("page_id", "");
            params.put("page_title", "");
            params.put("page_type", "");
        }
        return params;
    }

    public String getHashKey() {
        String entityId = this.conversionContext.getEntity() != null ? this.conversionContext.getEntity().getIdAsString() : "";
        StringBuilder sb = new StringBuilder();
        sb.append(this.remotablePluginAccessor.getKey()).append("|");
        sb.append(this.parameters.toString()).append("|");
        sb.append(this.body).append("|");
        sb.append(this.path).append("|");
        sb.append(entityId);
        return String.valueOf(sb.toString().hashCode());
    }

    public Map<String, String> getHeaders(String userId) {
        return this.createRequestContextParameters(userId).getHeaders();
    }

    private RequestContextParameters createRequestContextParameters(String userId) {
        return this.requestContextParameterFactory.create(userId, this.getAllContextParameters());
    }
}

