/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.integration.speakeasy;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.labs.speakeasy.external.SpeakeasyBackendService;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.remotable.plugin.integration.speakeasy.SpeakeasyEventListener;
import com.google.common.base.Preconditions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpeakeasyLoader
implements DisposableBean {
    private final ServiceTracker speakeasyBackendTracker;
    private final EventPublisher eventPublisher;
    private volatile Object eventListener;

    @Autowired
    public SpeakeasyLoader(final ModuleFactory moduleFactory, final EventPublisher eventPublisher, final BundleContext bundleContext) {
        Preconditions.checkNotNull((Object)moduleFactory);
        Preconditions.checkNotNull((Object)bundleContext);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.speakeasyBackendTracker = new ServiceTracker(bundleContext, "com.atlassian.labs.speakeasy.external.SpeakeasyBackendService", new ServiceTrackerCustomizer(){

            public Object addingService(ServiceReference reference) {
                SpeakeasyBackendService service = (SpeakeasyBackendService)bundleContext.getService(reference);
                if (SpeakeasyLoader.this.eventListener != null) {
                    eventPublisher.unregister(SpeakeasyLoader.this.eventListener);
                }
                SpeakeasyLoader.this.eventListener = new SpeakeasyEventListener(moduleFactory, bundleContext, service);
                eventPublisher.register(SpeakeasyLoader.this.eventListener);
                return service;
            }

            public void modifiedService(ServiceReference reference, Object service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                eventPublisher.unregister(SpeakeasyLoader.this.eventListener);
            }
        });
        this.speakeasyBackendTracker.open();
    }

    public void destroy() throws Exception {
        this.speakeasyBackendTracker.close();
        if (this.eventListener != null) {
            this.eventPublisher.unregister(this.eventListener);
        }
    }
}

