/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.rest.license;

import com.atlassian.plugin.remotable.host.common.service.license.LicenseDetailsRepresentation;
import com.atlassian.plugin.remotable.plugin.rest.license.PluginLicenses;
import com.atlassian.plugin.remotable.plugin.rest.license.Strings;
import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Date;
import org.joda.time.DateTime;

public class LicenseDetailsFactory {
    private static final Function<DateTime, Date> toDate = new Function<DateTime, Date>(){

        public Date apply(DateTime dateTime) {
            return dateTime.toDate();
        }
    };

    public static LicenseDetailsRepresentation createRemotablePluginLicense(PluginLicense pluginLicense) {
        return new LicenseDetailsRepresentation(pluginLicense.isValid(), pluginLicense.isEvaluation(), PluginLicenses.isNearlyExpired().apply((Object)pluginLicense), (Integer)pluginLicense.getEdition().getOrElse((Object)null), (Date)pluginLicense.getMaintenanceExpiryDate().map(toDate).getOrElse((Object)null), pluginLicense.getLicenseType().name(), pluginLicense.getCreationDate().toString(), pluginLicense.isEvaluation() ? (Date)pluginLicense.getExpiryDate().map(toDate).getOrElse((Object)null) : null, (String)pluginLicense.getMaintenanceExpiryDate().map(LicenseDetailsFactory.formatDate()).getOrElse((Object)null), (String)pluginLicense.getSupportEntitlementNumber().getOrElse((Object)null), pluginLicense.getOrganization().getName(), LicenseDetailsFactory.getContactsEmail(pluginLicense.getContacts()), pluginLicense.isEnterprise());
    }

    private static Function<DateTime, String> formatDate() {
        return new Function<DateTime, String>(){

            public String apply(DateTime dateTime) {
                return dateTime.toString();
            }
        };
    }

    private static String getContactsEmail(Iterable<Contact> contacts) {
        Iterable emails = Iterables.transform(contacts, (Function)new Function<Contact, String>(){

            public String apply(Contact contact) {
                return contact.getEmail();
            }
        });
        return (String)Strings.getFirstNonEmpty(emails).getOrElse((Object)null);
    }
}

