/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.loader.universalbinary;

import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBHttpRequestWrapper;
import com.atlassian.plugin.remotable.plugin.loader.universalbinary.UBServletContextWrapper;
import com.atlassian.plugin.util.ClassLoaderStack;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DelegatingUBServlet
extends HttpServlet {
    private final HttpServlet servlet;
    private String mountPath;
    private final ClassLoader classLoader;

    public DelegatingUBServlet(HttpServlet servlet, ClassLoader classLoader, String mountPath) {
        this.classLoader = classLoader;
        this.servlet = servlet;
        this.mountPath = mountPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ClassLoaderStack.push((ClassLoader)this.classLoader);
        try {
            String contextPath = ((UBServletContextWrapper)this.servlet.getServletContext()).getContextPath();
            UBHttpRequestWrapper wrapper = new UBHttpRequestWrapper(req, contextPath, this.mountPath);
            this.servlet.service((ServletRequest)wrapper, (ServletResponse)res);
        }
        finally {
            ClassLoaderStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        ClassLoaderStack.push((ClassLoader)this.classLoader);
        try {
            this.servlet.init(config);
        }
        finally {
            ClassLoaderStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ClassLoaderStack.push((ClassLoader)this.classLoader);
        try {
            this.servlet.destroy();
        }
        finally {
            ClassLoaderStack.pop();
        }
    }

    public boolean equals(Object obj) {
        return this.servlet.equals(obj);
    }

    public String getInitParameter(String name) {
        return this.servlet.getInitParameter(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return this.servlet.getInitParameterNames();
    }

    public ServletConfig getServletConfig() {
        return this.servlet.getServletConfig();
    }

    public ServletContext getServletContext() {
        return this.servlet.getServletContext();
    }

    public String getServletInfo() {
        return this.servlet.getServletInfo();
    }

    public String getServletName() {
        return this.servlet.getServletName();
    }

    public int hashCode() {
        return this.servlet.hashCode();
    }

    public void init() throws ServletException {
        this.servlet.init();
    }

    public void log(String message, Throwable t) {
        this.servlet.log(message, t);
    }

    public void log(String msg) {
        this.servlet.log(msg);
    }

    public String toString() {
        return this.servlet.toString();
    }
}

