/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.installer;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.remotable.plugin.OAuthLinkManager;
import com.atlassian.plugin.remotable.plugin.event.RemoteEventsHandler;
import com.atlassian.plugin.remotable.plugin.installer.RemotePluginArtifactFactory;
import com.atlassian.plugin.remotable.plugin.installer.RemotePluginInstaller;
import com.atlassian.plugin.remotable.spi.InstallationFailedException;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.util.WaitUntil;
import java.net.URI;
import java.util.Set;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class DefaultRemotePluginInstaller
implements RemotePluginInstaller {
    private final RemotePluginArtifactFactory remotePluginArtifactFactory;
    private final PluginController pluginController;
    private final PluginAccessor pluginAccessor;
    private final OAuthLinkManager oAuthLinkManager;
    private final RemoteEventsHandler remoteEventsHandler;
    private static final Logger log = LoggerFactory.getLogger(DefaultRemotePluginInstaller.class);

    @Autowired
    public DefaultRemotePluginInstaller(RemotePluginArtifactFactory remotePluginArtifactFactory, PluginController pluginController, PluginAccessor pluginAccessor, OAuthLinkManager oAuthLinkManager, RemoteEventsHandler remoteEventsHandler) {
        this.remotePluginArtifactFactory = remotePluginArtifactFactory;
        this.pluginController = pluginController;
        this.pluginAccessor = pluginAccessor;
        this.oAuthLinkManager = oAuthLinkManager;
        this.remoteEventsHandler = remoteEventsHandler;
    }

    @Override
    public String install(String username, URI registrationUrl, Document document) throws PermissionDeniedException {
        try {
            String pluginKey = this.getPluginKey(document);
            this.removeOldPlugin(pluginKey);
            PluginArtifact pluginArtifact = this.getPluginArtifact(username, registrationUrl, document);
            Set pluginKeys = this.pluginController.installPlugins(new PluginArtifact[]{pluginArtifact});
            if (pluginKeys.size() == 1) {
                String installedKey = (String)pluginKeys.iterator().next();
                final Plugin plugin = this.pluginAccessor.getPlugin(installedKey);
                WaitUntil.invoke((WaitUntil.WaitCondition)new WaitUntil.WaitCondition(){

                    public boolean isFinished() {
                        for (ModuleDescriptor desc : plugin.getModuleDescriptors()) {
                            if (DefaultRemotePluginInstaller.this.pluginAccessor.isPluginModuleEnabled(desc.getCompleteKey()) || !(desc instanceof UnrecognisedModuleDescriptor)) continue;
                            return false;
                        }
                        return true;
                    }

                    public String getWaitMessage() {
                        return "Waiting for all module descriptors to be resolved and enabled";
                    }
                });
                if (!this.pluginAccessor.isPluginEnabled(plugin.getKey())) {
                    String cause = "Plugin didn't install correctly";
                    for (ModuleDescriptor descriptor : plugin.getModuleDescriptors()) {
                        if (!(descriptor instanceof UnloadableModuleDescriptor)) continue;
                        cause = ((UnloadableModuleDescriptor)descriptor).getErrorText();
                        break;
                    }
                    throw new RuntimeException(cause);
                }
            } else {
                throw new RuntimeException("Plugin didn't install correctly", null);
            }
            this.remoteEventsHandler.pluginInstalled(pluginKey);
            log.info("Registered app '{}' by '{}'", (Object)pluginKey, (Object)username);
            return pluginKey;
        }
        catch (PermissionDeniedException ex) {
            log.warn("Unable to install remote plugin from '{}' by user '{}' due to permission issues: {}", new Object[]{registrationUrl, username, ex.getMessage()});
            log.debug("Installation failed due to permission issue", (Throwable)ex);
            throw ex;
        }
        catch (InstallationFailedException ex) {
            log.warn("Unable to install remote plugin from '{}' by user '{}' due to installation issue: {}", new Object[]{registrationUrl, username, ex.getMessage()});
            log.debug("Installation failed due to installation issue", (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            log.warn("Unable to install remote plugin from '{}' by user '{}'", (Object)registrationUrl, (Object)username);
            log.debug("Installation failed due to unknown issue", (Throwable)e);
            throw new InstallationFailedException(e.getCause() != null ? e.getCause() : e);
        }
    }

    private PluginArtifact getPluginArtifact(String username, URI registrationUrl, Document document) {
        if (document.getRootElement().attribute("plugins-version") != null) {
            return this.remotePluginArtifactFactory.create(registrationUrl, document, username);
        }
        throw new InstallationFailedException("Missing plugins-version");
    }

    private String getPluginKey(Document document) {
        return document.getRootElement().attributeValue("key");
    }

    private void removeOldPlugin(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin != null) {
            this.pluginController.uninstall(plugin);
        } else if (this.oAuthLinkManager.isAppAssociated(pluginKey)) {
            throw new PermissionDeniedException(pluginKey, "App key '" + pluginKey + "' is already associated with an OAuth link");
        }
    }
}

