/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.host.common.util.BundleUtil;
import com.atlassian.plugin.remotable.host.common.util.RemotablePluginManifestReader;
import com.atlassian.plugin.remotable.plugin.PermissionManager;
import com.atlassian.plugin.remotable.plugin.settings.SettingsManager;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.remotable.spi.permission.Permission;
import com.atlassian.plugin.remotable.spi.permission.PermissionModuleDescriptor;
import com.atlassian.plugin.remotable.spi.permission.PermissionsReader;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiScope;
import com.atlassian.plugin.remotable.spi.util.ServletUtils;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Document;
import org.osgi.framework.BundleContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class PermissionManagerImpl
implements PermissionManager {
    private final UserManager userManager;
    private final SettingsManager settingsManager;
    private final PluginAccessor pluginAccessor;
    private final PermissionsReader permissionsReader;
    private final BundleContext bundleContext;
    private final PluginModuleTracker<Permission, PermissionModuleDescriptor> permissionTracker;
    private final Set<String> NON_USER_ADMIN_PATHS = ImmutableSet.of((Object)"/rest/remotable-plugins/latest/macro/", (Object)"/rest/remotable-plugins/1/macro/");

    @Autowired
    public PermissionManagerImpl(UserManager userManager, SettingsManager settingsManager, PluginAccessor pluginAccessor, PluginEventManager pluginEventManager, PermissionsReader permissionsReader, BundleContext bundleContext) {
        this(userManager, settingsManager, pluginAccessor, permissionsReader, bundleContext, (PluginModuleTracker<Permission, PermissionModuleDescriptor>)new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, PermissionModuleDescriptor.class));
    }

    PermissionManagerImpl(UserManager userManager, SettingsManager settingsManager, PluginAccessor pluginAccessor, PermissionsReader permissionsReader, BundleContext bundleContext, PluginModuleTracker<Permission, PermissionModuleDescriptor> pluginModuleTracker) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.settingsManager = (SettingsManager)Preconditions.checkNotNull((Object)settingsManager);
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor);
        this.permissionsReader = (PermissionsReader)Preconditions.checkNotNull((Object)permissionsReader);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.permissionTracker = (PluginModuleTracker)Preconditions.checkNotNull(pluginModuleTracker);
    }

    @Override
    public Set<Permission> getPermissions(final InstallationMode mode) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)this.permissionTracker.getModules(), (Predicate)new Predicate<Permission>(){

            public boolean apply(Permission p) {
                return p.getInstallationModes().contains(mode);
            }
        }));
    }

    @Override
    public Set<String> getPermissionKeys(InstallationMode mode) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(this.getPermissions(mode), (Function)new Function<Permission, String>(){

            public String apply(Permission p) {
                return p.getKey();
            }
        }));
    }

    @Override
    public boolean isRequestInApiScope(HttpServletRequest req, String clientKey, String user) {
        if (user == null) {
            String pathInfo = ServletUtils.extractPathInfo((HttpServletRequest)req);
            for (String adminPath : this.NON_USER_ADMIN_PATHS) {
                if (!pathInfo.startsWith(adminPath)) continue;
                return true;
            }
        }
        final Set<String> permissions = this.getPermissionsForPlugin(clientKey);
        Iterable applicableScopes = Iterables.transform((Iterable)Iterables.filter((Iterable)this.permissionTracker.getModules(), (Predicate)new Predicate<Permission>(){

            public boolean apply(@Nullable Permission input) {
                return input instanceof ApiScope && permissions.contains(input.getKey());
            }
        }), (Function)new Function<Permission, ApiScope>(){

            public ApiScope apply(@Nullable Permission input) {
                return (ApiScope)input;
            }
        });
        for (ApiScope scope : applicableScopes) {
            if (!scope.allow(req, user)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getPermissionsForPlugin(String clientKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(clientKey);
        return plugin != null ? this.permissionsReader.getPermissionsForPlugin(plugin) : Collections.emptySet();
    }

    @Override
    public boolean canInstallRemotePluginsFromMarketplace(String username) {
        return username != null && (this.isDogfoodUser(username) || this.userManager.isAdmin(username));
    }

    private boolean inDogfoodingGroup(String username) {
        return this.userManager.isUserInGroup(username, "developers") || this.userManager.isUserInGroup(username, "atlassian-staff") || this.userManager.isUserInGroup(username, "test-users");
    }

    @Override
    public void requirePermission(String pluginKey, String permissionKey) throws PermissionDeniedException {
        if (!this.getPermissionsForPlugin(pluginKey).contains(permissionKey)) {
            throw new PermissionDeniedException(pluginKey, "Required permission '" + permissionKey + "' must be requested " + "for this plugin '" + pluginKey + "'");
        }
    }

    @Override
    public boolean hasPermission(String pluginKey, String permissionKey) throws PermissionDeniedException {
        return this.getPermissionsForPlugin(pluginKey).contains(permissionKey);
    }

    @Override
    public boolean canModifyRemotePlugin(String username, String pluginKey) {
        if (this.userManager.isAdmin(username)) {
            return true;
        }
        return this.isDogfoodUser(username) && username.equals(RemotablePluginManifestReader.getInstallerUser(BundleUtil.findBundleForPlugin(this.bundleContext, pluginKey)));
    }

    private boolean isDogfoodUser(String username) {
        return this.settingsManager.isAllowDogfooding() && this.inDogfoodingGroup(username);
    }

    @Override
    public boolean canRequestDeclaredPermissions(String username, Document descriptor, InstallationMode installationMode) {
        if (this.userManager.isSystemAdmin(username)) {
            return true;
        }
        Set requestedPermissions = this.permissionsReader.readPermissionsFromDescriptor(descriptor, installationMode);
        return this.getPermissionKeys(installationMode).containsAll(requestedPermissions);
    }

    @Override
    public boolean canInstallArbitraryRemotePlugins(String userName) {
        return this.userManager.isSystemAdmin(userName) || this.isDogfoodUser(userName);
    }
}

