/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.product.confluence;

import com.atlassian.confluence.plugin.descriptor.web.conditions.ActiveThemeCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.CanClusterCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.CanEditSpaceStylesCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.ConfluenceAdministratorCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.ContentHasAnyPermissionsSetCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.CreateContentCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.EmailAddressPublicCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.FavouritePageCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.FavouriteSpaceCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.HasAttachmentCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.HasBlogPostCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.HasPageCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.HasSpaceCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.HasTemplateCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.LatestVersionCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.NotPersonalSpaceCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.NotSharedModeCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.PrintableVersionCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.ShowingPageAttachmentsCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.SpaceFunctionPermissionCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.SystemAdministratorCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.ThreadedCommentsCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.TinyUrlSupportedCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.ViewingContentCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.ViewingOwnProfileCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.WritableDirectoryExistsCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.CanSignupCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.FollowingTargetUserCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.TargetUserCanSetStatusCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.TargetUserHasPersonalBlogCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.TargetUserHasPersonalSpaceCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserCanCreatePersonalSpaceCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserCanUpdateUserStatusCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserCanUseConfluenceCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserFavouritingTargetUserPersonalSpaceCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserHasPersonalBlogCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserHasPersonalSpaceCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserLoggedInCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserLoggedInEditableCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserWatchingPageCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserWatchingSpaceCondition;
import com.atlassian.confluence.plugin.descriptor.web.conditions.user.UserWatchingSpaceForContentTypeCondition;
import com.atlassian.confluence.plugin.descriptor.web.descriptors.ConfluenceWebItemModuleDescriptor;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.api.confluence.ConfluencePermissions;
import com.atlassian.plugin.remotable.spi.Permissions;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfluenceProductAccessor
implements ProductAccessor {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceProductAccessor.class);
    private final MultiQueueTaskManager taskManager;

    public ConfluenceProductAccessor(MultiQueueTaskManager taskManager) {
        this.taskManager = (MultiQueueTaskManager)Preconditions.checkNotNull((Object)taskManager);
    }

    public WebItemModuleDescriptor createWebItemModuleDescriptor() {
        return new ConfluenceWebItemModuleDescriptor();
    }

    public String getPreferredAdminSectionKey() {
        return "system.admin/admin.pages";
    }

    public int getPreferredAdminWeight() {
        return 100;
    }

    public String getKey() {
        return "confluence";
    }

    public int getPreferredGeneralWeight() {
        return 1000;
    }

    public String getPreferredGeneralSectionKey() {
        return "system.browse";
    }

    public int getPreferredProfileWeight() {
        return 100;
    }

    public String getPreferredProfileSectionKey() {
        return "system.profile";
    }

    public Map<String, String> getLinkContextParams() {
        return ImmutableMap.of((Object)"page_id", (Object)"$!page.id", (Object)"page_type", (Object)"$!page.type");
    }

    public void sendEmail(String userName, final Email email, String bodyAsHtml, String bodyAsText) {
        email.setBody(bodyAsText);
        try {
            ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)MailFactory.class.getClassLoader(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    SMTPMailServer defaultSMTPMailServer = MailFactory.getServerManager().getDefaultSMTPMailServer();
                    if (defaultSMTPMailServer != null) {
                        try {
                            defaultSMTPMailServer.send(email);
                        }
                        catch (MailException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        log.warn("Can't send email - no mail server defined");
                    }
                }
            });
        }
        catch (RuntimeException e) {
            log.warn("Unable to send email: " + email, (Throwable)e);
        }
    }

    public void flushEmail() {
        this.taskManager.flush("mail");
    }

    public Map<String, Class<? extends Condition>> getConditions() {
        HashMap conditions = Maps.newHashMap();
        conditions.put("not_personal_space", NotPersonalSpaceCondition.class);
        conditions.put("user_is_confluence_administrator", ConfluenceAdministratorCondition.class);
        conditions.put("user_can_use_confluence", UserCanUseConfluenceCondition.class);
        conditions.put("user_can_update_user_status", UserCanUpdateUserStatusCondition.class);
        conditions.put("not_shared_mode", NotSharedModeCondition.class);
        conditions.put("email_address_public", EmailAddressPublicCondition.class);
        conditions.put("content_has_any_permissions_set", ContentHasAnyPermissionsSetCondition.class);
        conditions.put("user_watching_space_for_content_type", UserWatchingSpaceForContentTypeCondition.class);
        conditions.put("space_function_permission", SpaceFunctionPermissionCondition.class);
        conditions.put("following_target_user", FollowingTargetUserCondition.class);
        conditions.put("has_space", HasSpaceCondition.class);
        conditions.put("target_user_can_set_status", TargetUserCanSetStatusCondition.class);
        conditions.put("user_favouriting_target_user_personal_space", UserFavouritingTargetUserPersonalSpaceCondition.class);
        conditions.put("user_is_sysadmin", SystemAdministratorCondition.class);
        conditions.put("favourite_page", FavouritePageCondition.class);
        conditions.put("threaded_comments", ThreadedCommentsCondition.class);
        conditions.put("user_is_logged_in", UserLoggedInCondition.class);
        conditions.put("user_has_personal_space", UserHasPersonalSpaceCondition.class);
        conditions.put("can_signup", CanSignupCondition.class);
        conditions.put("target_user_has_personal_space", TargetUserHasPersonalSpaceCondition.class);
        conditions.put("viewing_content", ViewingContentCondition.class);
        conditions.put("viewing_own_profile", ViewingOwnProfileCondition.class);
        conditions.put("can_cluster", CanClusterCondition.class);
        conditions.put("active_theme", ActiveThemeCondition.class);
        conditions.put("printable_version", PrintableVersionCondition.class);
        conditions.put("writable_directory_exists", WritableDirectoryExistsCondition.class);
        conditions.put("user_can_create_personal_space", UserCanCreatePersonalSpaceCondition.class);
        conditions.put("tiny_url_supported", TinyUrlSupportedCondition.class);
        conditions.put("latest_version", LatestVersionCondition.class);
        conditions.put("has_page", HasPageCondition.class);
        conditions.put("create_content", CreateContentCondition.class);
        conditions.put("can_edit_space_styles", CanEditSpaceStylesCondition.class);
        conditions.put("showing_page_attachments", ShowingPageAttachmentsCondition.class);
        conditions.put("has_template", HasTemplateCondition.class);
        conditions.put("user_has_personal_blog", UserHasPersonalBlogCondition.class);
        conditions.put("has_attachment", HasAttachmentCondition.class);
        conditions.put("target_user_has_personal_blog", TargetUserHasPersonalBlogCondition.class);
        conditions.put("user_watching_space", UserWatchingSpaceCondition.class);
        conditions.put("has_blog_post", HasBlogPostCondition.class);
        conditions.put("user_logged_in_editable", UserLoggedInEditableCondition.class);
        conditions.put("user_watching_page", UserWatchingPageCondition.class);
        conditions.put("favourite_space", FavouriteSpaceCondition.class);
        return conditions;
    }

    public Set<String> getAllowedPermissions(InstallationMode installationMode) {
        if (installationMode == InstallationMode.REMOTE) {
            return Sets.union((Set)Permissions.DEFAULT_REMOTE_PERMISSIONS, (Set)ConfluencePermissions.ALL_REMOTE_PERMISSIONS);
        }
        return Collections.emptySet();
    }
}

