/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.osgi.bridge.external.PluginRetrievalService;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.plugin.PermissionManager;
import com.atlassian.plugin.remotable.plugin.descriptor.DescriptorValidatorProvider;
import com.atlassian.plugin.remotable.plugin.descriptor.InputStreamSupplierLSInput;
import com.atlassian.plugin.remotable.plugin.descriptor.PluginDescriptorValidatorProvider;
import com.atlassian.plugin.remotable.spi.InstallationFailedException;
import com.atlassian.plugin.remotable.spi.permission.Permission;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiResourceInfo;
import com.atlassian.plugin.remotable.spi.permission.scope.ApiScope;
import com.atlassian.plugin.remotable.spi.product.ProductAccessor;
import com.atlassian.plugin.remotable.spi.util.Dom4jUtils;
import com.atlassian.plugin.schema.spi.SchemaDocumented;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.io.DocumentSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Component
public final class DescriptorValidator {
    private final Plugin plugin;
    private final ProductAccessor productAccessor;
    private final WebResourceManager webResourceManager;
    private final PermissionManager permissionManager;
    private final DescriptorValidatorProvider pluginDescriptorValidatorProvider;

    @Autowired
    public DescriptorValidator(PluginRetrievalService pluginRetrievalService, ProductAccessor productAccessor, WebResourceManager webResourceManager, PermissionManager permissionManager, PluginDescriptorValidatorProvider pluginDescriptorValidatorProvider) {
        this.productAccessor = productAccessor;
        this.webResourceManager = webResourceManager;
        this.permissionManager = permissionManager;
        this.plugin = pluginRetrievalService.getPlugin();
        this.pluginDescriptorValidatorProvider = pluginDescriptorValidatorProvider;
    }

    public void validate(URI url, Document document) {
        InstallationMode installationMode = InstallationMode.LOCAL;
        boolean useNamespace = document.getRootElement().getNamespaceURI().equals(this.pluginDescriptorValidatorProvider.getSchemaNamespace(installationMode));
        String builtSchema = this.buildSchema(this.pluginDescriptorValidatorProvider, useNamespace, installationMode);
        try {
            Schema schema = DescriptorValidator.getSchema((InputSupplier<? extends Reader>)CharStreams.newReaderSupplier((String)builtSchema), new PluginLSResourceResolver(this.plugin));
            Validator validator = schema.newValidator();
            DocumentSource source = new DocumentSource(document);
            source.setSystemId(url.toString());
            validator.validate((Source)source);
        }
        catch (SAXException e) {
            throw new InstallationFailedException("Unable to parse the descriptor: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.pluginDescriptorValidatorProvider.performSecondaryValidations(document);
    }

    static Schema getSchema(InputSupplier<? extends Reader> schemaInput, LSResourceResolver resourceResolver) throws IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Reader schemaReader = null;
        try {
            schemaReader = (Reader)schemaInput.getInput();
            schemaFactory.setResourceResolver(resourceResolver);
            Schema schema = schemaFactory.newSchema(new StreamSource(schemaReader));
            return schema;
        }
        catch (SAXParseException e) {
            throw new RuntimeException(String.format("Couldn't parse schema (line %s, column %s):\n%s", e.getLineNumber(), e.getColumnNumber(), CharStreams.toString(schemaInput)), e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Couldn't parse schema:\n" + CharStreams.toString(schemaInput), e);
        }
        finally {
            Closeables.closeQuietly((Closeable)schemaReader);
        }
    }

    public String getPluginSchema(InstallationMode installationMode) {
        try {
            return this.buildSchema(this.pluginDescriptorValidatorProvider, true, installationMode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String buildSchema(DescriptorValidatorProvider descriptorValidatorProvider, boolean usesNamespace, InstallationMode installationMode) {
        HashSet includedDocIds = Sets.newHashSet();
        Element root = Dom4jUtils.parseDocument((URL)descriptorValidatorProvider.getSchemaUrl()).getRootElement();
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("type", "text/xsl");
        arguments.put("href", this.webResourceManager.getStaticPluginResource("com.atlassian.labs.remoteapps-plugin:schema-xsl", "xs3p.xsl", UrlMode.ABSOLUTE));
        DocumentFactory factory = new DocumentFactory();
        ProcessingInstruction pi = factory.createProcessingInstruction("xml-stylesheet", arguments);
        root.getDocument().content().add(0, pi);
        String ns = descriptorValidatorProvider.getSchemaNamespace(installationMode);
        if (usesNamespace) {
            root.addAttribute("targetNamespace", ns);
            root.addAttribute("xmlns", ns);
        }
        this.processIncludes(root.getDocument(), includedDocIds);
        Element modulesChoice = (Element)root.selectSingleNode("/xs:schema/xs:complexType[@name='" + descriptorValidatorProvider.getRootElementName() + "']//xs:choice");
        for (com.atlassian.plugin.schema.spi.Schema schema : descriptorValidatorProvider.getModuleSchemas(installationMode)) {
            String id = schema.getFileName();
            if (!includedDocIds.contains(id)) {
                includedDocIds.add(id);
                Document doc = schema.getDocument();
                Preconditions.checkNotNull((Object)doc, (Object)("Document from generator " + schema.getFileName() + " is null"));
                this.processIncludes(doc, includedDocIds);
                for (Element child : doc.getRootElement().elements()) {
                    root.elements().add(0, child.detach());
                }
            }
            Element module = modulesChoice.addElement("xs:element").addAttribute("name", schema.getElementName()).addAttribute("type", schema.getComplexType()).addAttribute("maxOccurs", schema.getMaxOccurs());
            Dom4jUtils.addSchemaDocumentation((Element)module, (SchemaDocumented)schema);
        }
        Element permissionsType = (Element)root.selectSingleNode("/xs:schema/xs:simpleType[@name='PermissionValueType']/xs:restriction");
        for (Permission permission : this.permissionManager.getPermissions()) {
            Element enumeration = permissionsType.addElement("xs:enumeration").addAttribute("value", permission.getKey());
            Element doc = Dom4jUtils.addSchemaDocumentation((Element)enumeration, (SchemaDocumented)permission);
            if (!(permission instanceof ApiScope)) continue;
            ApiScope apiScope = (ApiScope)permission;
            Element resources = doc.addElement("resources");
            for (ApiResourceInfo resource : apiScope.getApiResourceInfos()) {
                Element res = resources.addElement("resource").addAttribute("path", resource.getPath()).addAttribute("httpMethod", resource.getHttpMethod());
                if (resource.getRpcMethod() == null) continue;
                res.addAttribute("rpcMethod", resource.getRpcMethod());
            }
        }
        return Dom4jUtils.printNode((Node)root.getDocument());
    }

    private void processIncludes(Document doc, Set<String> includedDocIds) {
        Element root = doc.getRootElement();
        List rootIncludes = root.elements("include");
        for (Element include : rootIncludes) {
            int pos = include.getParent().elements().indexOf(include);
            include.detach();
            String schemaLocation = include.attributeValue("schemaLocation");
            if (includedDocIds.contains(schemaLocation)) continue;
            URL resource = this.plugin.getResource("/xsd/" + schemaLocation);
            if (resource == null) {
                throw new IllegalArgumentException("Can't find resource: " + schemaLocation);
            }
            Document includeDoc = Dom4jUtils.parseDocument((URL)resource);
            this.processIncludes(includeDoc, includedDocIds);
            if (schemaLocation.equals("common.xsd")) {
                this.insertAvailableLinkContextParams(includeDoc, this.productAccessor.getLinkContextParams());
                this.insertAvailableWebConditions(includeDoc, this.productAccessor.getConditions());
            }
            List includeChildren = includeDoc.getRootElement().elements();
            Collections.reverse(includeChildren);
            for (Element child : includeChildren) {
                if (!root.elements().isEmpty()) {
                    root.elements().add(pos, child.detach());
                    continue;
                }
                root.add(child.detach());
            }
            includedDocIds.add(schemaLocation);
        }
    }

    private void insertAvailableLinkContextParams(Document includeDoc, Map<String, String> linkContextParams) {
        Element restriction = (Element)includeDoc.selectSingleNode("/xs:schema/xs:simpleType[@name='LinkContextParameterNameType']/xs:restriction");
        if (restriction != null) {
            for (Map.Entry<String, String> entry : linkContextParams.entrySet()) {
                String name = entry.getKey();
                restriction.addElement("xs:enumeration").addAttribute("value", name);
            }
        }
    }

    private void insertAvailableWebConditions(Document includeDoc, Map<String, Class<? extends Condition>> webConditions) {
        Element restriction = (Element)includeDoc.selectSingleNode("/xs:schema/xs:simpleType[@name='ConditionNameType']/xs:restriction");
        if (restriction != null) {
            for (String name : webConditions.keySet()) {
                restriction.addElement("xs:enumeration").addAttribute("value", name);
            }
        }
    }

    private static class PluginLSResourceResolver
    implements LSResourceResolver {
        private final Plugin plugin;

        private PluginLSResourceResolver(Plugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            final String resource = systemId;
            InputSupplier<InputStream> inputSupplier = new InputSupplier<InputStream>(){

                public InputStream getInput() throws IOException {
                    return PluginLSResourceResolver.this.plugin.getResourceAsStream("/xsd/" + resource);
                }
            };
            return new InputStreamSupplierLSInput(systemId, publicId, inputSupplier);
        }
    }
}

