/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http.bigpipe;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.remotable.api.service.RequestContext;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.BigPipe;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.BigPipeManager;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.ConsumableBigPipe;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.DataChannel;
import com.atlassian.plugin.remotable.api.service.http.bigpipe.HtmlChannel;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.AbstractChannel;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.ContentEnvelopePromise;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.MetadataProvider;
import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.RequestIdAccessor;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.security.random.SecureRandomFactory;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.atlassian.util.concurrent.ForwardingPromise;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;

public final class DefaultBigPipeManager
implements BigPipeManager,
DisposableBean {
    private static final SecureRandom secureRandom = SecureRandomFactory.newInstance();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WebResourceManager webResourceManager;
    private final RequestIdAccessor requestIdAccessor = new RequestIdAccessor();
    private final UserIdRetriever userIdRetriever;
    ScheduledExecutorService cleanupThread = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("Big Pipe Cleanup");
            return t;
        }
    });
    private final ConcurrentMap<String, BigPipeImpl> bigPipeImpls = CopyOnWriteMap.newHashMap();

    DefaultBigPipeManager(WebResourceManager webResourceManager, final RequestContext requestContext) {
        this(webResourceManager, new UserIdRetriever(){

            @Override
            public String getUserId() {
                return requestContext.getUserId();
            }
        });
    }

    @Autowired
    public DefaultBigPipeManager(WebResourceManager webResourceManager, final UserManager userManager) {
        this(webResourceManager, new UserIdRetriever(){

            @Override
            public String getUserId() {
                return userManager.getRemoteUsername();
            }
        });
    }

    private DefaultBigPipeManager(WebResourceManager webResourceManager, UserIdRetriever userIdRetriever) {
        this.webResourceManager = webResourceManager;
        this.userIdRetriever = userIdRetriever;
        this.cleanupThread.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DefaultBigPipeManager.this.cleanExpiredRequests();
            }
        }, 2L, 1L, TimeUnit.MINUTES);
    }

    private void cleanExpiredRequests() {
        for (BigPipeImpl contentSet : this.bigPipeImpls.values()) {
            if (!contentSet.isExpired()) continue;
            contentSet.removeBigPipeImpl();
        }
    }

    public RequestIdAccessor getRequestIdAccessor() {
        return this.requestIdAccessor;
    }

    public void destroy() throws Exception {
        this.cleanupThread.shutdownNow();
    }

    public BigPipe getBigPipe() {
        return this.getBigPipe(this.getRequestId(), true);
    }

    public Option<ConsumableBigPipe> getConsumableBigPipe() {
        return this.getConsumableBigPipe(this.getRequestId());
    }

    Option<ConsumableBigPipe> getConsumableBigPipe(String requestId) {
        BigPipeImpl bigPipeImpl;
        BigPipeImpl result = null;
        if (requestId != null && (bigPipeImpl = (BigPipeImpl)this.bigPipeImpls.get(requestId)) != null) {
            result = bigPipeImpl.getPendingChannelIds().size() > 0 ? bigPipeImpl : null;
        }
        return Option.option(result);
    }

    private String getRequestId() {
        String requestId = this.requestIdAccessor.getRequestId();
        if (requestId == null) {
            throw new IllegalStateException("Current thread does not have a request id");
        }
        return requestId;
    }

    private BigPipeImpl getBigPipe(String requestId, boolean createIfAbsent) {
        if (requestId == null) {
            throw new NullPointerException("requestId");
        }
        BigPipeImpl bigPipeImpl = (BigPipeImpl)this.bigPipeImpls.get(requestId);
        if (bigPipeImpl == null) {
            if (createIfAbsent) {
                BigPipeImpl newBigPipeImpl = new BigPipeImpl(requestId, this.userIdRetriever.getUserId());
                bigPipeImpl = this.bigPipeImpls.putIfAbsent(requestId, newBigPipeImpl);
                if (bigPipeImpl == null) {
                    bigPipeImpl = newBigPipeImpl;
                }
            } else {
                throw new IllegalArgumentException("No bigpipe instance found for request id: '" + requestId + "'");
            }
        }
        return bigPipeImpl;
    }

    static /* synthetic */ SecureRandom access$1000() {
        return secureRandom;
    }

    private class HtmlPromise
    extends ForwardingPromise<String>
    implements MetadataProvider {
        private final Promise<String> delegate;
        private final String contentId = "bp-" + Long.toHexString(Math.abs(DefaultBigPipeManager.access$1000().nextLong()));
        private InternalHandler handler;

        public HtmlPromise(Promise<String> delegate) {
            this.delegate = delegate;
        }

        public String getInitialContent() {
            if (this.delegate().isDone()) {
                String content = (String)this.delegate().claim();
                this.handler.removeContent();
                return content;
            }
            return "<span id=\"" + this.contentId + "\" class=\"bp-loading\"></span>";
        }

        @Override
        public Map<String, String> getMetadata() {
            return Collections.singletonMap("contentId", this.contentId);
        }

        protected Promise<String> delegate() {
            return this.delegate;
        }

        public void setHandler(InternalHandler handler) {
            this.handler = handler;
        }
    }

    private final class BigPipeImpl
    implements BigPipe,
    ConsumableBigPipe {
        private final List<InternalHandler> handlers;
        private final HtmlChannelImpl htmlChannel;
        private final ConcurrentMap<String, DataChannelImpl> dataChannels;
        private final long expiry;
        private final String requestId;
        private final String userId;
        private final Object lock = new Object();

        BigPipeImpl(String requestId, String userId) {
            this.requestId = requestId;
            this.userId = userId;
            this.handlers = new CopyOnWriteArrayList<InternalHandler>();
            this.htmlChannel = new HtmlChannelImpl();
            this.dataChannels = CopyOnWriteMap.newHashMap();
            this.expiry = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(30L);
        }

        public String getRequestId() {
            return this.requestId;
        }

        public HtmlChannel getHtmlChannel() {
            return this.htmlChannel;
        }

        public DataChannel getDataChannel(String channelId) {
            DataChannelImpl newChannel;
            Preconditions.checkNotNull((Object)channelId);
            if ("html".equals(channelId)) {
                throw new IllegalArgumentException("Data channels must not use the reserved channel id 'html'");
            }
            DataChannel channel = (DataChannel)this.dataChannels.get(channelId);
            if (channel == null && (channel = (DataChannel)this.dataChannels.putIfAbsent(channelId, newChannel = new DataChannelImpl(channelId))) == null) {
                channel = newChannel;
            }
            return channel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String consumeContent() {
            Set<String> pendingChannelIds;
            this.verifyUser(this.userId);
            ArrayListMultimap content = ArrayListMultimap.create();
            Object object = this.lock;
            synchronized (object) {
                if (this.hasMoreContent()) {
                    this.removeAllFinishedHandlers((Multimap<String, JSONObject>)content);
                    if (!this.hasMoreContent()) {
                        DefaultBigPipeManager.this.log.info("All content has been consumed for request id {}", (Object)this.requestId);
                        this.removeBigPipeImpl();
                    }
                }
                pendingChannelIds = this.getPendingChannelIds();
            }
            return this.convertContentToJson(content.asMap(), pendingChannelIds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String waitForContent() {
            Set<String> pendingChannelIds;
            this.verifyUser(this.userId);
            ArrayListMultimap content = ArrayListMultimap.create();
            Object object = this.lock;
            synchronized (object) {
                pendingChannelIds = this.getPendingChannelIds();
                if (this.hasMoreContent() || !pendingChannelIds.isEmpty()) {
                    this.removeAllFinishedHandlers((Multimap<String, JSONObject>)content);
                    if (content.isEmpty() && !this.isExpired()) {
                        try {
                            long timeout = this.expiry - System.currentTimeMillis();
                            if (timeout > 0L) {
                                this.lock.wait(timeout);
                            }
                            this.removeAllFinishedHandlers((Multimap<String, JSONObject>)content);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    if (this.isExpired()) {
                        DefaultBigPipeManager.this.log.info("Timeout waiting for {} jobs for request id {}", (Object)this.handlers.size(), (Object)this.requestId);
                        this.removeBigPipeImpl();
                    }
                    pendingChannelIds = this.getPendingChannelIds();
                }
            }
            return this.convertContentToJson(content.asMap(), pendingChannelIds);
        }

        private String convertContentToJson(Map<String, Collection<JSONObject>> contentByChannel, Set<String> pendingChannelIds) {
            JSONObject response = new JSONObject();
            JSONArray items = new JSONArray();
            for (Collection<JSONObject> collection : contentByChannel.values()) {
                for (JSONObject json : collection) {
                    items.add((Object)json);
                }
            }
            response.put((Object)"items", (Object)items);
            JSONArray pendingChannelsArray = new JSONArray();
            pendingChannelsArray.addAll(pendingChannelIds);
            response.put((Object)"pending", (Object)pendingChannelsArray);
            return response.toString();
        }

        private InternalHandler addHandler(InternalHandler handler) {
            this.handlers.add(handler);
            return handler;
        }

        public void removeContent(InternalHandler handler) {
            this.handlers.remove(handler);
        }

        private void removeBigPipeImpl() {
            this.handlers.clear();
            DefaultBigPipeManager.this.bigPipeImpls.remove(this.requestId);
        }

        private boolean hasMoreContent() {
            return !this.handlers.isEmpty();
        }

        private void verifyUser(String userId) {
            if (userId == null ? this.userId != null : !userId.equals(this.userId)) {
                throw new RuntimeException("Current user is not authorized to access requested bigpipe content");
            }
        }

        private void removeAllFinishedHandlers(Multimap<String, JSONObject> result) {
            for (InternalHandler handler : Sets.newHashSet(this.handlers)) {
                if (!handler.isFinished()) continue;
                this.removeContent(handler);
                result.put((Object)handler.getChannelId(), handler.getContent().claim());
            }
        }

        private boolean isExpired() {
            return System.currentTimeMillis() >= this.expiry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyConsumers() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        private Set<String> getPendingChannelIds() {
            HashSet pendingChannelIds = Sets.newHashSet();
            for (InternalHandler handler : this.handlers) {
                pendingChannelIds.add(handler.getChannelId());
            }
            if (this.htmlChannel.isRetained()) {
                pendingChannelIds.add(this.htmlChannel.getId());
            }
            for (DataChannelImpl dataChannel : this.dataChannels.values()) {
                if (!dataChannel.isRetained()) continue;
                pendingChannelIds.add(dataChannel.getId());
            }
            return Collections.unmodifiableSet(pendingChannelIds);
        }

        private InternalHandler registerContentPromise(String channelId, Promise<String> stringPromise) {
            ContentEnvelopePromise envelopePromise = new ContentEnvelopePromise(stringPromise, channelId);
            DefaultBigPipeManager.this.webResourceManager.requireResource("com.atlassian.labs.remoteapps-plugin:big-pipe");
            envelopePromise.then((FutureCallback)new FutureCallback<JSONObject>(){

                public void onSuccess(JSONObject json) {
                    BigPipeImpl.this.notifyConsumers();
                }

                public void onFailure(Throwable t) {
                    BigPipeImpl.this.notifyConsumers();
                }
            });
            InternalHandler handler = new InternalHandler(channelId, this, envelopePromise);
            this.addHandler(handler);
            return handler;
        }

        private class DataChannelImpl
        extends AbstractChannel
        implements DataChannel {
            DataChannelImpl(String id) {
                super(id);
            }

            public void promiseContent(Promise<String> promise) {
                this.retainWhile(promise);
                BigPipeImpl.this.registerContentPromise(this.getId(), (Promise<String>)promise);
            }
        }

        private class HtmlChannelImpl
        extends AbstractChannel
        implements HtmlChannel {
            HtmlChannelImpl() {
                super("html");
            }

            public String promiseContent(Promise<String> promise) {
                this.retainWhile(promise);
                HtmlPromise htmlPromise = new HtmlPromise(promise);
                InternalHandler handler = BigPipeImpl.this.registerContentPromise("html", (Promise<String>)((Promise)htmlPromise));
                htmlPromise.setHandler(handler);
                return htmlPromise.getInitialContent();
            }
        }
    }

    private class InternalHandler {
        private final String channelId;
        private final BigPipeImpl bigPipe;
        private final Promise<JSONObject> jsonPromise;

        public InternalHandler(String channelId, BigPipeImpl bigPipeImpl, Promise<JSONObject> jsonPromise) {
            this.channelId = channelId;
            this.bigPipe = bigPipeImpl;
            this.jsonPromise = jsonPromise.then((FutureCallback)new FutureCallback<JSONObject>(){

                public void onSuccess(JSONObject json) {
                    InternalHandler.this.bigPipe.notifyConsumers();
                }

                public void onFailure(Throwable t) {
                    InternalHandler.this.bigPipe.notifyConsumers();
                }
            });
        }

        public String getChannelId() {
            return this.channelId;
        }

        public Promise<JSONObject> getContent() {
            return this.jsonPromise;
        }

        public boolean isFinished() {
            return this.jsonPromise.isDone();
        }

        public void removeContent() {
            this.bigPipe.removeContent(this);
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static interface UserIdRetriever {
        public String getUserId();
    }
}

