/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Response;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.remotable.api.InstallationMode;
import com.atlassian.plugin.remotable.descriptor.InvalidDescriptorException;
import com.atlassian.plugin.remotable.descriptor.util.FormatConverter;
import com.atlassian.plugin.remotable.host.common.util.BundleUtil;
import com.atlassian.plugin.remotable.host.common.util.RemotablePluginManifestReader;
import com.atlassian.plugin.remotable.plugin.PermissionManager;
import com.atlassian.plugin.remotable.plugin.descriptor.DescriptorValidator;
import com.atlassian.plugin.remotable.plugin.installer.RemotePluginInstaller;
import com.atlassian.plugin.remotable.spi.InstallationFailedException;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import com.atlassian.plugin.remotable.spi.RemotablePluginInstallationService;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.Document;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemotablePluginInstallationService
implements RemotablePluginInstallationService {
    private final RemotePluginInstaller remotePluginInstaller;
    private final UserManager userManager;
    private final BundleContext bundleContext;
    private final PermissionManager permissionManager;
    private final PluginController pluginController;
    private final PluginAccessor pluginAccessor;
    private final HttpClient httpClient;
    private final FormatConverter formatConverter;
    private final DescriptorValidator descriptorValidator;
    private static final Logger log = LoggerFactory.getLogger(DefaultRemotablePluginInstallationService.class);

    public DefaultRemotablePluginInstallationService(RemotePluginInstaller remotePluginInstaller, UserManager userManager, BundleContext bundleContext, PermissionManager permissionManager, PluginController pluginController, PluginAccessor pluginAccessor, HttpClient httpClient, FormatConverter formatConverter, DescriptorValidator descriptorValidator) {
        this.remotePluginInstaller = remotePluginInstaller;
        this.userManager = userManager;
        this.bundleContext = bundleContext;
        this.permissionManager = permissionManager;
        this.pluginController = pluginController;
        this.pluginAccessor = pluginAccessor;
        this.httpClient = httpClient;
        this.formatConverter = formatConverter;
        this.descriptorValidator = descriptorValidator;
    }

    public String install(String username, String registrationUrl) throws PermissionDeniedException, InstallationFailedException {
        URI parsedRegistrationUri;
        try {
            parsedRegistrationUri = new URI(registrationUrl);
        }
        catch (URISyntaxException e) {
            throw new InstallationFailedException("Invalid URI: '" + registrationUrl + "'");
        }
        this.validateCanInstallArbitraryPlugins(username);
        Document pluginDescriptor = this.getPluginDescriptor(registrationUrl);
        String pluginKey = pluginDescriptor.getRootElement().attributeValue("key");
        this.validateCanEditPluginIfExists(username, pluginKey);
        this.validateDeclaredPermissionsCanBeRequested(username, pluginDescriptor);
        return this.installPlugin(username, parsedRegistrationUri, pluginDescriptor);
    }

    public String installFromMarketplace(String username, String pluginKey) throws PermissionDeniedException, InstallationFailedException {
        this.validateCanInstallPluginsFromMarketplace(username);
        String pluginDescriptorUrl = this.getPluginDescriptorUrl(pluginKey);
        Document pluginDescriptor = this.getPluginDescriptor(pluginDescriptorUrl);
        return this.installPlugin(username, URI.create(pluginDescriptorUrl), pluginDescriptor);
    }

    private String installPlugin(String username, URI parsedRegistrationUri, Document pluginDescriptor) {
        try {
            String appKey = this.remotePluginInstaller.install(username, parsedRegistrationUri, pluginDescriptor);
            log.info("Remote plugin '{}' installed by '{}' successfully", (Object)appKey, (Object)username);
            return appKey;
        }
        catch (PermissionDeniedException ex) {
            log.warn("Permission denied for installation of '" + parsedRegistrationUri + "'" + " by user '" + username + "'", (Throwable)ex);
            throw ex;
        }
        catch (InstallationFailedException ex) {
            log.warn("Installation failed for registration URL '" + parsedRegistrationUri + "'" + " and user '" + username + "'", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            log.warn("Installation failed for registration URL '" + parsedRegistrationUri + "'" + " and user '" + username + "'", (Throwable)ex);
            throw new InstallationFailedException((Throwable)ex);
        }
    }

    private void validateCanInstallArbitraryPlugins(String username) {
        if (!this.permissionManager.canInstallArbitraryRemotePlugins(username)) {
            throw new PermissionDeniedException("User '" + username + "' cannot install arbitrary plugins");
        }
    }

    private void validateCanInstallPluginsFromMarketplace(String username) {
        if (!this.permissionManager.canInstallRemotePluginsFromMarketplace(username)) {
            throw new PermissionDeniedException("Unauthorized access by '" + username + "'");
        }
    }

    private void validateCanEditPluginIfExists(String username, String pluginKey) {
        if (this.doesAppExist(pluginKey) && !this.permissionManager.canModifyRemotePlugin(username, pluginKey)) {
            throw new PermissionDeniedException("Unauthorized modification of plugin '" + pluginKey + "' by '" + username + "'");
        }
    }

    private void validateDeclaredPermissionsCanBeRequested(String username, Document descriptor) {
        if (!this.permissionManager.canRequestDeclaredPermissions(username, descriptor, InstallationMode.REMOTE)) {
            throw new PermissionDeniedException("Unauthorized request of permissions by '" + username + "'");
        }
    }

    public void uninstall(String username, String appKey) throws PermissionDeniedException {
        this.validateAppExists(appKey);
        this.validateCanInstallPluginsFromMarketplace(username);
        this.validateCanEditPluginIfExists(username, appKey);
        this.pluginController.uninstall(this.pluginAccessor.getPlugin(appKey));
        log.info("Remote plugin '{}' uninstalled by '{}' successfully", (Object)appKey, (Object)username);
    }

    public String getPluginKey(String registrationUrl) {
        return this.getPluginDescriptor(registrationUrl).getRootElement().attributeValue("key");
    }

    Document getPluginDescriptor(final String registrationUrl) {
        return (Document)this.httpClient.newRequest(registrationUrl).setHeader("Accept", "application/xml").get().transform().ok((Function)new Function<Response, Document>(){

            public Document apply(Response response) {
                try {
                    Document document = DefaultRemotablePluginInstallationService.this.formatConverter.toDocument(registrationUrl, response.getHeader("Content-Type"), response.getEntity());
                    DefaultRemotablePluginInstallationService.this.descriptorValidator.validate(URI.create(registrationUrl), document);
                    return document;
                }
                catch (InvalidDescriptorException e) {
                    throw new InstallationFailedException((Throwable)e);
                }
            }
        }).others((Function)new Function<Response, Document>(){

            public Document apply(Response response) {
                throw new InstallationFailedException("Unable to retrieve the descriptor (" + response.getStatusCode() + ") - " + response.getStatusText());
            }
        }).fail((Function)new Function<Throwable, Document>(){

            public Document apply(Throwable input) {
                log.debug("Error retrieving descriptor", input);
                throw new InstallationFailedException(String.format("Unable to contact and retrieve descriptor from '%s', message is: %s", registrationUrl, input.getMessage()), input);
            }
        }).claim();
    }

    String getPluginDescriptorUrl(final String pluginKey) {
        return (String)this.httpClient.newRequest("https://marketplace.atlassian.com/rest/1.0/plugins/" + pluginKey).get().transform().ok((Function)new Function<Response, String>(){

            public String apply(Response input) {
                try {
                    JSONObject object = new JSONObject(input.getEntity());
                    JSONObject version = object.getJSONObject("version");
                    if (version == null || !DefaultRemotablePluginInstallationService.this.isValidPluginSystemVersion(version)) {
                        throw new InstallationFailedException("Unable to find valid plugin version for key " + pluginKey);
                    }
                    return DefaultRemotablePluginInstallationService.this.findDescriptorUrl(version);
                }
                catch (JSONException e) {
                    throw new InstallationFailedException("Unable to parse marketplace response for key " + pluginKey, (Throwable)e);
                }
            }
        }).otherwise((Function)new Function<Throwable, String>(){

            public String apply(Throwable input) {
                throw new InstallationFailedException("Error retrieving response from marketplace for key " + pluginKey, input);
            }
        }).claim();
    }

    private String findUrl(JSONArray links, String rel) throws JSONException {
        for (int x = 0; x < links.length(); ++x) {
            JSONObject link = links.getJSONObject(x);
            if (!rel.equals(link.getString("rel"))) continue;
            return link.getString("href");
        }
        return null;
    }

    public String findDescriptorUrl(JSONObject version) throws JSONException {
        JSONArray links = version.getJSONArray("links");
        String url = this.findUrl(links, "descriptor");
        if (url == null) {
            url = this.findUrl(links, "binary");
        }
        if (url == null) {
            throw new JSONException("No descriptor url found for descriptor");
        }
        return url;
    }

    private boolean isValidPluginSystemVersion(JSONObject version) throws JSONException {
        if (version != null) {
            String type = version.getString("addOnType");
            return "Plugins 3".equalsIgnoreCase(type) || "three".equalsIgnoreCase(type);
        }
        return false;
    }

    public Set<String> reinstallRemotePlugins(String remoteUsername) {
        if (!this.userManager.isSystemAdmin(remoteUsername)) {
            throw new PermissionDeniedException("Only system administrators are allowed to reinstall all remote plugins");
        }
        HashSet reinstalledKeys = Sets.newHashSet();
        for (Plugin plugin : this.pluginAccessor.getPlugins()) {
            try {
                Bundle bundle = BundleUtil.findBundleForPlugin(this.bundleContext, plugin.getKey());
                if (bundle == null || !RemotablePluginManifestReader.isRemotePlugin(bundle)) continue;
                String registrationUri = RemotablePluginManifestReader.getRegistrationUrl(bundle);
                reinstalledKeys.add(this.install(remoteUsername, registrationUri));
            }
            catch (Exception ex) {
                log.warn("Unable to reinstall remote plugin " + plugin.getKey(), (Throwable)ex);
            }
        }
        return reinstalledKeys;
    }

    private boolean doesAppExist(String appKey) {
        Bundle bundle = BundleUtil.findBundleForPlugin(this.bundleContext, appKey);
        return bundle != null && RemotablePluginManifestReader.isRemotePlugin(bundle);
    }

    private void validateAppExists(String appKey) {
        if (!this.doesAppExist(appKey)) {
            throw new PermissionDeniedException(appKey, "Remote plugin '" + appKey + "' doesn't exist");
        }
    }
}

