/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service;

import com.atlassian.plugin.remotable.api.service.RequestContext;
import com.atlassian.plugin.remotable.api.service.SignedRequestHandler;
import com.atlassian.plugin.remotable.host.common.service.AuthenticationInfo;
import com.atlassian.plugin.remotable.host.common.service.http.DefaultRequestContext;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationFilter
implements Filter {
    private static final String AUTH_COOKIE_NAME = "AP-Auth-State";
    private final SignedRequestHandler signedRequestHandler;
    private final DefaultRequestContext requestContext;
    private final boolean canSpoofAuth;

    public AuthenticationFilter(SignedRequestHandler signedRequestHandler, RequestContext requestContext) {
        this.signedRequestHandler = signedRequestHandler;
        this.requestContext = (DefaultRequestContext)requestContext;
        this.canSpoofAuth = Boolean.getBoolean("atlassian.dev.mode") || Boolean.getBoolean("auth.spoof");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        try {
            AuthenticationInfo info;
            HttpServletRequest req = (HttpServletRequest)sreq;
            HttpServletResponse res = (HttpServletResponse)sres;
            this.requestContext.setRequest(req);
            URI uri = URI.create(req.getRequestURI());
            if (!(uri.getPath().contains("/public/") || req.getHeader("Authorization") == null && req.getParameter("oauth_signature") == null)) {
                info = this.authenticateOauth(req);
                this.storeAuthentication(res, info);
            } else if (this.canSpoofAuth && req.getHeader("X-CONSUMER-KEY") != null) {
                String clientKey = req.getHeader("X-CONSUMER-KEY");
                String userId = req.getHeader("X-USER-ID");
                info = new AuthenticationInfo(clientKey, userId);
                this.storeAuthentication(res, info);
            } else {
                info = this.retrieveAuthentication(req);
            }
            if (info != null) {
                this.requestContext.setClientKey(info.getClientKey());
                this.requestContext.setUserId(info.getUserId());
            }
            chain.doFilter(sreq, sres);
        }
        finally {
            DefaultRequestContext.clear();
        }
    }

    private AuthenticationInfo authenticateOauth(HttpServletRequest req) throws ServletException {
        String clientKey = this.signedRequestHandler.validateRequest(req);
        Map params = req.getParameterMap();
        String[] userIds = (String[])params.get("user_id");
        String userId = userIds != null && userIds.length == 1 ? userIds[0] : req.getHeader("AP-CTX-user-id");
        return new AuthenticationInfo(clientKey, userId);
    }

    private AuthenticationInfo retrieveAuthentication(HttpServletRequest req) {
        AuthenticationInfo info = null;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            String header;
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                if (name == null || !name.equals(AUTH_COOKIE_NAME)) continue;
                info = AuthenticationInfo.decode(cookie.getValue());
                break;
            }
            if (info == null && (header = req.getHeader(AUTH_COOKIE_NAME)) != null) {
                info = AuthenticationInfo.decode(header);
            }
        }
        return info;
    }

    private void storeAuthentication(HttpServletResponse res, AuthenticationInfo info) {
        res.addCookie(new Cookie(AUTH_COOKIE_NAME, info.encode()));
    }

    public void destroy() {
        DefaultRequestContext.clear();
    }
}

