/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.plugin.installer;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.remotable.plugin.OAuthLinkManager;
import com.atlassian.plugin.remotable.plugin.event.RemoteEventsHandler;
import com.atlassian.plugin.remotable.plugin.installer.RemotePluginArtifactFactory;
import com.atlassian.plugin.remotable.plugin.installer.RemotePluginInstaller;
import com.atlassian.plugin.remotable.spi.InstallationFailedException;
import com.atlassian.plugin.remotable.spi.PermissionDeniedException;
import java.net.URI;
import org.dom4j.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class DefaultRemotePluginInstaller
implements RemotePluginInstaller {
    private final RemotePluginArtifactFactory remotePluginArtifactFactory;
    private final PluginController pluginController;
    private final PluginAccessor pluginAccessor;
    private final OAuthLinkManager oAuthLinkManager;
    private final RemoteEventsHandler remoteEventsHandler;
    private static final Logger log = LoggerFactory.getLogger(DefaultRemotePluginInstaller.class);

    @Autowired
    public DefaultRemotePluginInstaller(RemotePluginArtifactFactory remotePluginArtifactFactory, PluginController pluginController, PluginAccessor pluginAccessor, OAuthLinkManager oAuthLinkManager, RemoteEventsHandler remoteEventsHandler) {
        this.remotePluginArtifactFactory = remotePluginArtifactFactory;
        this.pluginController = pluginController;
        this.pluginAccessor = pluginAccessor;
        this.oAuthLinkManager = oAuthLinkManager;
        this.remoteEventsHandler = remoteEventsHandler;
    }

    @Override
    public String install(String username, URI registrationUrl, Document document) throws PermissionDeniedException {
        try {
            String pluginKey = this.getPluginKey(document);
            this.removeOldPlugin(pluginKey);
            PluginArtifact pluginArtifact = this.getPluginArtifact(username, registrationUrl, document);
            this.pluginController.installPlugins(new PluginArtifact[]{pluginArtifact}).iterator().next();
            this.remoteEventsHandler.pluginInstalled(pluginKey);
            log.info("Registered app '{}' by '{}'", (Object)pluginKey, (Object)username);
            return pluginKey;
        }
        catch (PermissionDeniedException ex) {
            log.warn("Unable to install remote plugin from '{}' by user '{}' due to permission issues: {}", new Object[]{registrationUrl, username, ex.getMessage()});
            log.debug("Installation failed due to permission issue", (Throwable)ex);
            throw ex;
        }
        catch (InstallationFailedException ex) {
            log.warn("Unable to install remote plugin from '{}' by user '{}' due to installation issue: {}", new Object[]{registrationUrl, username, ex.getMessage()});
            log.debug("Installation failed due to installation issue", (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            log.warn("Unable to install remote plugin from '{}' by user '{}'", (Object)registrationUrl, (Object)username);
            log.debug("Installation failed due to unknown issue", (Throwable)e);
            throw new InstallationFailedException(e.getCause() != null ? e.getCause() : e);
        }
    }

    private PluginArtifact getPluginArtifact(String username, URI registrationUrl, Document document) {
        if (document.getRootElement().attribute("plugins-version") != null) {
            return this.remotePluginArtifactFactory.create(registrationUrl, document, username);
        }
        throw new InstallationFailedException("Missing plugins-version");
    }

    private String getPluginKey(Document document) {
        return document.getRootElement().attributeValue("key");
    }

    private void removeOldPlugin(String pluginKey) {
        Plugin plugin = this.pluginAccessor.getPlugin(pluginKey);
        if (plugin != null) {
            this.pluginController.uninstall(plugin);
        } else if (this.oAuthLinkManager.isAppAssociated(pluginKey)) {
            throw new PermissionDeniedException(pluginKey, "App key '" + pluginKey + "' is already associated with an OAuth link");
        }
    }
}

