/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.remotable.host.common.service.http.bigpipe;

import com.atlassian.plugin.remotable.host.common.service.http.bigpipe.BigPipeImpl;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BigPipeContentFilter
implements Filter {
    private final BigPipeImpl bigPipe;

    public BigPipeContentFilter(BigPipeImpl bigPipe) {
        this.bigPipe = (BigPipeImpl)Preconditions.checkNotNull((Object)bigPipe);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        String requestId;
        HttpServletRequest req = (HttpServletRequest)sreq;
        HttpServletResponse res = (HttpServletResponse)sres;
        String uri = req.getRequestURI();
        int idIndex = uri.lastIndexOf(47);
        String string = requestId = idIndex >= 0 && idIndex < uri.length() - 1 ? uri.substring(idIndex + 1) : null;
        if (requestId != null) {
            res.setStatus(200);
            res.setContentType("application/json");
            res.setCharacterEncoding("UTF-8");
            res.setHeader("Cache-Control", "no-cache");
            String result = this.bigPipe.waitForContent(requestId);
            res.getWriter().write(result);
        } else {
            res.sendError(404);
        }
    }

    public void destroy() {
    }
}

