package com.atlassian.plugins.less;

import com.atlassian.lesscss.spi.UriResolver;
import com.atlassian.util.concurrent.Nullable;

import java.net.URI;

public interface UriResolverManager {

    Iterable<UriResolver> getResolvers();

    default UriResolver getResolverOrThrow(URI uri) {
        UriResolver uriResolver = getResolver(uri);
        if (uriResolver == null) {
            throw new IllegalArgumentException("Unsupported URI " + uri.toASCIIString());
        }
        return uriResolver;
    }

    default boolean isUriSupported(URI uri) {
        return getResolver(uri) != null;
    }

    @Nullable
    default UriResolver getResolver(URI uri) {
        for (UriResolver uriResolver : getResolvers()) {
            if (uriResolver.supports(uri)) {
                return uriResolver;
            }
        }
        return null;
    }

}
