package com.atlassian.plugins.less;

import com.atlassian.webresource.api.assembler.resource.PrebakeError;

import java.util.List;

/**
 * Encapsulates the location of the root LESS file and the prebake errors generated from its dependencies.
 */
public class LessPrebakeError implements PrebakeError {

    private final String location;
    private final List<PrebakeError> errors;

    public LessPrebakeError(String location, List<PrebakeError> errors) {
        this.location = location;
        this.errors = errors;
    }

    @Override
    public String toString() {
        return "LessPrebakeError{" +
                "location='" + location + '\'' +
                ", errors=" + errors +
                '}';
    }
}
