package com.atlassian.plugins.less;

import com.atlassian.lesscss.LessCompiler;
import com.atlassian.lesscss.RhinoLessCompiler;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

public class LessCompilerSupplier implements Supplier<LessCompiler> {

    private final Supplier<LessCompiler> delegate;

    public LessCompilerSupplier() {
        this.delegate = Suppliers.memoize(new Supplier<LessCompiler>() {
            @Override
            public LessCompiler get() {
                return new RhinoLessCompiler();
            }
        });
    }

    @Override
    public LessCompiler get() {
        return delegate.get();
    }
}
