/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.less;

import com.atlassian.lesscss.spi.UriResolver;
import com.atlassian.plugin.servlet.ServletContextFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public class WebStaticUriResolver
implements UriResolver {
    private final ServletContextFactory servletContextFactory;

    public WebStaticUriResolver(ServletContextFactory servletContextFactory) {
        this.servletContextFactory = servletContextFactory;
    }

    public boolean exists(URI uri) {
        try {
            return this.servletContextFactory.getServletContext().getResource(uri.getPath()) != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public String encodeState(URI uri) {
        URLConnection connection = null;
        try {
            URL url = this.servletContextFactory.getServletContext().getResource(uri.getPath());
            connection = url.openConnection();
            String string = String.valueOf(connection.getLastModified());
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public InputStream open(URI uri) throws IOException {
        InputStream is = this.servletContextFactory.getServletContext().getResourceAsStream(uri.getPath());
        if (is == null) {
            throw new IOException(uri.getPath() + " does not exist in the servletContext");
        }
        return is;
    }

    public boolean supports(URI uri) {
        return "webstatic".equals(uri.getScheme());
    }
}

