/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.conversion;

import com.aspose.cells.CellsHelper;
import com.aspose.cells.License;
import com.aspose.slides.FontsLoader;
import com.aspose.words.FontSettings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

public class AsposeUtils {
    private static final String PROP_SEARCH_FONT_PATH = "confluence.document.conversion.fontpath";
    private static final String PROP_WORDS_DEFAULT_FONT_NAME = "confluence.document.conversion.words.defaultfontname";
    private static final String PROP_SLIDES_DEFAULT_REGULAR_FONT_NAME = "confluence.document.conversion.slides.defaultfontname.regular";
    private static final String PROP_SLIDES_DEFAULT_ASIAN_FONT_NAME = "confluence.document.conversion.slides.defaultfontname.asian";
    private static final String PROP_SLIDES_DEFAULT_SYMBOL_FONT_NAME = "confluence.document.conversion.slides.defaultfontname.symbol";
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean IS_OS_WINDOWS = OS_NAME.startsWith("Windows");
    private static final boolean IS_OS_MAC = OS_NAME.startsWith("Mac");
    private static final String DEFAULT_SEARCH_FONT_PATH = IS_OS_WINDOWS ? System.getenv("WINDIR") + "\\Fonts" : (IS_OS_MAC ? "/Library/Fonts" : "/usr/share/fonts");
    private static final String DEFAULT_SLIDES_DEFAULT_ASIAN_FONT = "TakaoPGothic";
    public static final String SLIDES_DEFAULT_REGULAR_FONT = System.getProperty("confluence.document.conversion.slides.defaultfontname.regular");
    public static final String SLIDES_DEFAULT_ASIAN_FONT = System.getProperty("confluence.document.conversion.slides.defaultfontname.asian", "TakaoPGothic");
    public static final String SLIDES_DEFAULT_SYMBOL_FONT = System.getProperty("confluence.document.conversion.slides.defaultfontname.symbol");
    private static final String AsposeLicense = "<License>\n  <Data>\n    <LicensedTo>Atlassian Pty Ltd</LicensedTo>\n    <EmailTo>jtblin@atlassian.com</EmailTo>\n    <LicenseType>Site OEM</LicenseType>\n    <LicenseNote>Limited to 10 developers, unlimited physical locations</LicenseNote>\n    <OrderID>190218181227</OrderID>\n    <UserID>83733</UserID>\n    <OEM>This is a redistributable license</OEM>\n    <Products>\n      <Product>Aspose.Total for Java</Product>\n    </Products>\n    <EditionType>Enterprise</EditionType>\n    <SerialNumber>d2641a93-8598-4483-9be9-c7262bcf999b</SerialNumber>\n    <SubscriptionExpiry>20200415</SubscriptionExpiry>\n    <LicenseVersion>3.0</LicenseVersion>\n    <LicenseInstructions>https://purchase.aspose.com/policies/use-license</LicenseInstructions>\n  </Data>\n  <Signature>XtoPIE5szINWPoBUUSswLu9qDT7yNi8llhS3ixV9TQj+6DOvReQ0Gxe4tvPz1TDoav6NtAwG/rZ5FyT59HBJ/eX2yLmOBAuaa1PajushZEvvLR/N5d6U6veFnexfdFfcvqJuWgJIahJDSrixis2jakSm2pXpUoNmVxbFeRdmnn8=</Signature>\n</License>";

    public static void license() {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AsposeUtils.class.getClassLoader());
            try {
                com.aspose.imaging.License licenseImg = new com.aspose.imaging.License();
                licenseImg.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                com.aspose.slides.License licenseSlides = new com.aspose.slides.License();
                licenseSlides.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                com.aspose.words.License licenseWords = new com.aspose.words.License();
                licenseWords.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                License licenseCells = new License();
                licenseCells.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                com.aspose.pdf.License licensePdf = new com.aspose.pdf.License();
                licensePdf.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static void configureFonts() {
        String path;
        File basePath;
        String defaultWordsFont = System.getProperty(PROP_WORDS_DEFAULT_FONT_NAME);
        if (defaultWordsFont != null) {
            FontSettings.getDefaultInstance().setDefaultFontName(defaultWordsFont);
        }
        if (!((basePath = new File(path = System.getProperty(PROP_SEARCH_FONT_PATH, DEFAULT_SEARCH_FONT_PATH))).isDirectory() || path.equals(DEFAULT_SEARCH_FONT_PATH) || new File(path = DEFAULT_SEARCH_FONT_PATH).isDirectory())) {
            return;
        }
        FontSettings.getDefaultInstance().setFontsFolder(path, true);
        FontsLoader.loadExternalFonts((String[])new String[]{path});
        CellsHelper.setFontDir((String)path);
    }
}

