require([
    "jquery"
], function (
    $
) {
    var connectionStatusTemplateMap = {
        "CONNECTED": "connectedStatus",
        "PARTIAL_CONNECTIVITY": "partialConnectivityStatus",
        "NOT_CONNECTED": "notConnectedStatus",
        "UNKNOWN": "unknownStatus",
        "OAUTH_FAILURE": "oauthFailureStatus"
    };

    var connectionStatusViews = {
        "CONNECTED": {
            status: HipChat.Templates.Configuration.ConnectionStatus.connectedStatus
        },
        "PARTIALLY_CONNECTED": {
            status: HipChat.Templates.Configuration.ConnectionStatus.partialConnectivityStatus,
            toolTipTitle: AJS.I18n.getText("plugins.hipchat.admin.connection.status.partial.connectivity.tooltip.title"),
            toolTipDescription: AJS.I18n.getText("plugins.hipchat.admin.connection.status.partial.connectivity.tooltip.description")
        },
        "NO_CONNECTION": {
            status: HipChat.Templates.Configuration.ConnectionStatus.notConnectedStatus,
            toolTipTitle: AJS.I18n.getText("plugins.hipchat.admin.connection.status.not.connected.tooltip.title"),
            toolTipDescription: AJS.I18n.getText("plugins.hipchat.admin.connection.status.not.connected.tooltip.description")
        },
        "UNKNOWN": {
            status: HipChat.Templates.Configuration.ConnectionStatus.unknownStatus,
            toolTipTitle: AJS.I18n.getText("plugins.hipchat.admin.connection.status.unknown.tooltip.title"),
            toolTipDescription: AJS.I18n.getText("plugins.hipchat.admin.connection.status.unknown.tooltip.description")
        },
        "OAUTH_FAILURE": {
            status: HipChat.Templates.Configuration.ConnectionStatus.oauthFailureStatus,
            toolTipTitle: AJS.I18n.getText("plugins.hipchat.admin.connection.status.oauth.failure.tooltip.title"),
            toolTipDescription: AJS.I18n.getText("plugins.hipchat.admin.connection.status.oauth.failure.tooltip.description")
        }
    };

    function getViewDataForStatus(data) {
        var view = connectionStatusViews[data];
        if (view === undefined) {
            view = connectionStatusTemplateMap.UNKNOWN;
        }

        return view;
    }

    function getConnectionStatusHtml(data) {
        var view = getViewDataForStatus(data);

        return view.status({extraClasses: view.toolTipDescription !== undefined ? "has-tooltip" : ""});
    }

    function getConnectionStatus() {
        return $.ajax({
            url: AJS.contextPath() + "/rest/hipchat/integration/1.0/connection-status",
            cache: false,
            dataType: 'json',
            type: "GET"
        });
    }

    function initConnectionStatusTooltip($connectionStatus, data) {
        var viewData = getViewDataForStatus(data);
        if (viewData.toolTipDescription !== undefined) {
            AJS.InlineDialog($connectionStatus, "connection-status-tooltip", function (content, trigger, showPopup) {

                var html = HipChat.Templates.Configuration.ConnectionStatus.connectivityTooltip({
                    title: viewData.toolTipTitle,
                    description: viewData.toolTipDescription,
                    link: viewData.toolTipLink
                });
                content.html(html);

                showPopup();
            }, {
                onHover: true,
                gravity: 'w'
            });
        }
    }

    function updateConnectionStatus(status) {
        var $connectionStatus = $(".hipchat-connection-status");
        $connectionStatus.html(getConnectionStatusHtml(status));
        initConnectionStatusTooltip($connectionStatus, status);
    }

    AJS.toInit(function($) {
        var $connectionStatus = $(".hipchat-connection-status");
        if ($connectionStatus.length > 0) {
            $connectionStatus.spin();
            getConnectionStatus().done(function(status) {
                updateConnectionStatus(status);
            }).fail(function() {
                updateConnectionStatus("UNKNOWN");
            }).always(function() {
                $connectionStatus.spinStop();
            });
        }
    });
});
