AJS.toInit(function ($) {
    var installButton = $("#enable-hipchat-button");
    var URIS = {
        begin: $("#oauth2-begin-uri").val(),
        redirect: $("#redirect-uri").val()
    };
    var Template = HipChat.Templates.Configuration;

    function doRedirect(hipchatOauthUri) {
        window.location = hipchatOauthUri;
    }

    var handleClick = function (elem) {
        var postData = {
            url: URIS.begin,
            type: "POST",
            contentType: 'application/x-www-form-urlencoded',
            data: {
                redirect: URIS.redirect
            }
        };

        AJS.safe.ajax(postData)
                .done(doRedirect);
        return false;
    };
    installButton.click(handleClick);

    var error = $("#oauth2-error-message");
    var statusCode = $("#oauth2-error-status-code");
    if (error.length > 0) {
        var banner = $("#hipchat-configuration-top-banner");
        var body = Template.errorMessage({statusCode: statusCode.val()});
        banner.html(AJS.messages.error({
            title: "Error message",
            body: body
        }));
        $("#oauth2-retry-link").click(handleClick);
    }
});