/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.user;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.users.User;
import com.atlassian.hipchat.api.users.UserService;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatUserId;
import com.atlassian.plugins.hipchat.api.events.UserInviteNotPermissionedEvent;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.api.user.InviteUserPageResolver;
import com.atlassian.plugins.hipchat.user.HipChatUserMapper;
import com.atlassian.plugins.hipchat.user.HipChatUserScopeService;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import io.atlassian.fugue.Option;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInviteUserPageResolver
implements InviteUserPageResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultInviteUserPageResolver.class);
    private final UserManager userManager;
    private final HipChatUserMapper hipChatUserMapper;
    private final HipChatUserScopeService hipChatUserScopeService;
    private final HipChatLinkProvider hipChatLinkProvider;
    private final EventPublisher eventPublisher;
    private final int TIMEOUT_SECONDS = 10;

    public DefaultInviteUserPageResolver(UserManager userManager, HipChatUserMapper hipChatUserMapper, HipChatUserScopeService hipChatUserScopeService, HipChatLinkProvider hipChatLinkProvider, EventPublisher eventPublisher) {
        this.userManager = userManager;
        this.hipChatUserMapper = hipChatUserMapper;
        this.hipChatUserScopeService = hipChatUserScopeService;
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public InvitePage resolvePageToRender() {
        Option<HipChatLink> linkOption = this.hipChatLinkProvider.getDefaultLink();
        if (linkOption.isEmpty()) {
            this.eventPublisher.publish((Object)new UserInviteNotPermissionedEvent());
            return InvitePage.NOT_PERMISSIONED;
        }
        HipChatLink link = (HipChatLink)linkOption.get();
        UserKey remoteUserKey = this.userManager.getRemoteUserKey();
        Option<HipChatUserId> hipChatUserIdOption = this.hipChatUserMapper.findHipChatUserIdWithPersonalToken(remoteUserKey);
        if (hipChatUserIdOption.isEmpty()) {
            return InvitePage.AUTHORIZE;
        }
        if (!this.isHipChatUserGroupAdmin(link.getAddonApi().users(), (HipChatUserId)hipChatUserIdOption.get())) {
            this.eventPublisher.publish((Object)new UserInviteNotPermissionedEvent());
            return InvitePage.NOT_PERMISSIONED;
        }
        Option<Set<HipChatScope>> scopesOption = this.hipChatUserScopeService.requestScopesForUser(remoteUserKey);
        if (scopesOption.isEmpty() || !((Set)scopesOption.get()).contains((Object)HipChatScope.AdminGroup)) {
            return InvitePage.AUTHORIZE;
        }
        return InvitePage.INVITE;
    }

    private boolean isHipChatUserGroupAdmin(UserService userService, HipChatUserId hcUserId) {
        try {
            Result userResult = (Result)userService.getUser(hcUserId.asEntityId()).get(10L, TimeUnit.SECONDS);
            if (userResult.isError()) {
                return false;
            }
            User user = (User)userResult.success();
            return user.getIsGroupAdmin();
        }
        catch (TimeoutException e) {
            LOGGER.warn("Timed out waiting for Hipchat user details.", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Error while trying to fetch Hipchat user details.", (Throwable)e);
            return false;
        }
    }

    public static enum InvitePage {
        AUTHORIZE,
        INVITE,
        NOT_PERMISSIONED;

    }
}

