/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.condition;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.api.user.HipChatUserFinder;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import io.atlassian.fugue.Option;
import java.util.Map;

public class UserLinkedWithHipChatCondition
implements Condition {
    private final HipChatLinkProvider hipChatLinkProvider;
    private final HipChatUserFinder hipChatUserMapper;
    private final UserManager userManager;

    public UserLinkedWithHipChatCondition(HipChatLinkProvider hipChatLinkProvider, HipChatUserFinder hipChatUserMapper, UserManager userManager) {
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.hipChatUserMapper = hipChatUserMapper;
        this.userManager = userManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Option<HipChatLink> defaultLink = this.hipChatLinkProvider.getDefaultLink();
        UserKey userKey = this.userManager.getRemoteUserKey();
        return userKey != null && defaultLink.isDefined() && this.isLinkedToUser(userKey);
    }

    private boolean isLinkedToUser(UserKey userKey) {
        return this.hipChatUserMapper.findHipChatUserIdWithPersonalToken(userKey).isDefined();
    }
}

