/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.compat.legacy;

import com.atlassian.annotations.Internal;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.rooms.CollapsedRoom;
import com.atlassian.hipchat.api.rooms.ExpandedRoom;
import com.atlassian.hipchat.api.rooms.MessageBgColor;
import com.atlassian.plugins.hipchat.api.HipChatUserId;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPI;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPIService;
import com.atlassian.plugins.hipchat.api.compat.legacy.HipChatConfiguration;
import com.atlassian.plugins.hipchat.api.compat.legacy.HipChatRoomsClient;
import com.atlassian.plugins.hipchat.api.compat.legacy.Message;
import com.atlassian.plugins.hipchat.api.compat.legacy.Room;
import com.atlassian.plugins.hipchat.api.notification.DefaultHipChatNotificationOptions;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationOptions;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Internal
public final class HipChatV1APIService
implements HipChatCompatAPIService {
    private static final Logger log = LoggerFactory.getLogger(HipChatCompatAPI.class);
    private final HipChatConfiguration manager;
    private final HipChatRoomsClient client;
    private final ApplicationProperties applicationProperties;

    public HipChatV1APIService(HipChatConfiguration manager, HipChatRoomsClient client, ApplicationProperties applicationProperties) {
        this.manager = manager;
        this.client = client;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public void notifyUser(@Nonnull String toID, @Nonnull String msg) {
        throw new UnsupportedOperationException("Sending private messages to users does not work in V1 of the API. Please upgrade your connection to V2.");
    }

    @Override
    public void notifyUser(@Nonnull String toID, @Nonnull String msg, @Nonnull HipChatNotificationOptions options) {
        throw new UnsupportedOperationException("Sending private messages to users does not work in V1 of the API. Please upgrade your connection to V2.");
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg) {
        this.notifyRoom(toID, msg, HipChatNotificationOptions.NONE);
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull HipChatNotificationOptions options) {
        if (this.isEnabled()) {
            Promise<Result<Void>> message = this.client.message(toID, this.applicationProperties.getDisplayName(), msg, (Option<Message.Format>)Option.none(), this.getBackgroundColorOf(options.getBackgroundColor()), (Option<Boolean>)Option.some((Object)options.isNotifyingClients()));
            message.done(response -> {
                if (response.isError()) {
                    log.warn(" Error communicating to Hipchat [{}]", (Object)response.error());
                }
            });
        }
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull Option<MessageBgColor> color) {
        this.notifyRoom(toID, msg, new DefaultHipChatNotificationOptions.DefaultHipChatNotificationOptionsBuilder().setBackgroundColor(color).build());
    }

    @Override
    public void notifyRoom(@Nonnull String toID, @Nonnull String msg, @Nonnull Option<MessageBgColor> color, boolean notifyClients) {
        this.notifyRoom(toID, msg, new DefaultHipChatNotificationOptions.DefaultHipChatNotificationOptionsBuilder().setBackgroundColor(color).setNotifyingClients(notifyClients).build());
    }

    @Override
    public Promise<Result<List<CollapsedRoom>>> getAllPublicRooms() {
        return this.client.list().map(input -> {
            if (input.isSuccess()) {
                Iterable publicRooms = Iterables.transform((Iterable)Iterables.filter((Iterable)((Iterable)input.success()), HipChatV1APIService.isPublicRoom()), HipChatV1APIService.convertToCollapsedRoom());
                return Result.success(ImmutableList.copyOf((Iterable)publicRooms));
            }
            return input.asError();
        });
    }

    @Override
    public Promise<Result<List<CollapsedRoom>>> getAllRooms() {
        return this.getAllPublicRooms();
    }

    @Override
    public Promise<Map<String, Result<ExpandedRoom>>> expandRoomsForIds(Iterable<String> roomIds) {
        return this.client.list().flatMap(response -> {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            if (response != null && response.isSuccess()) {
                List rooms = (List)response.success();
                Collection filteredCollection = rooms.stream().filter(room -> Iterables.any((Iterable)roomIds, id -> id.equals(String.valueOf(room.getId())))).collect(Collectors.toList());
                for (Room room2 : filteredCollection) {
                    builder.put((Object)String.valueOf(room2.getId()), Result.success(HipChatV1APIService.transform(room2)));
                }
            }
            return Promises.promise((Object)builder.build());
        });
    }

    @Override
    public HipChatCompatAPIService.Version getCurrentVersion() {
        return HipChatCompatAPIService.Version.V1;
    }

    @Override
    public boolean isEnabled() {
        return this.manager.getApiToken().isDefined();
    }

    @Override
    public Option<String> getGroupName() {
        return Option.none();
    }

    @Override
    public Option<String> getApiUrl() {
        return Option.some((Object)this.manager.getApiBaseUrl());
    }

    @Override
    public Promise<Result<ExpandedRoom>> createRoom(String name, HipChatUserId owner, Option<String> topic) {
        return this.client.create(name, Long.parseLong(owner.asEntityId()), (Option<Boolean>)Option.none(), topic, (Option<Boolean>)Option.option((Object)false)).flatMap(input -> {
            if (input.isSuccess()) {
                com.atlassian.hipchat.api.rooms.impl.Room expandedRoom = HipChatV1APIService.transform((Room)input.success());
                return Promises.promise(Result.success(expandedRoom));
            }
            return Promises.promise(input.asError());
        });
    }

    @Override
    public Promise<Result<Void>> deleteRoom(String roomNameOrId) {
        return this.client.delete(roomNameOrId);
    }

    @Override
    public Promise<Result<Boolean>> userExists(String emailAddress) {
        throw new UnsupportedOperationException("Not implemented for the V1 API");
    }

    private Option<Message.BackgroundColor> getBackgroundColorOf(Option<MessageBgColor> color) {
        if (!color.isDefined()) {
            return Option.none();
        }
        try {
            return Option.some((Object)((Object)Message.BackgroundColor.valueOf(((MessageBgColor)((Object)color.get())).name())));
        }
        catch (Exception e) {
            log.warn("The color {} does not exist in our matrix.", (Object)((MessageBgColor)((Object)color.get())).name());
            return Option.none();
        }
    }

    private static com.atlassian.hipchat.api.rooms.impl.Room transform(Room room) {
        return new com.atlassian.hipchat.api.rooms.impl.Room(String.valueOf(room.getId()), null, room.getName(), room.getCreated(), room.getLastActive(), null, room.isArchived(), false, null, null, null, null, null, room.getJid());
    }

    private static Function<Room, CollapsedRoom> convertToCollapsedRoom() {
        return room -> com.atlassian.hipchat.api.rooms.impl.Room.collapsed(room.getName(), String.valueOf(room.getId()), room.getPrivacy());
    }

    private static Predicate<Room> isPublicRoom() {
        return input -> !input.isPrivate();
    }
}

