/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor.extensions;

import com.atlassian.hipchat.api.connect.descriptor.HipChatCapability;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Condition;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Name;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public final class Action
implements HipChatCapability,
Comparable<Action> {
    private final String key;
    private final Name name;
    private final String target;
    private final String location;
    private final List<Condition> conditions;

    public String getKey() {
        return this.key;
    }

    public Name getName() {
        return this.name;
    }

    public String getTarget() {
        return this.target;
    }

    @JsonCreator
    public Action(@JsonProperty(value="key") String key, @JsonProperty(value="name") Name name, @JsonProperty(value="location") String location, @JsonProperty(value="target") String target, @JsonProperty(value="conditions") Condition[] conditions) {
        this.conditions = conditions != null ? Arrays.asList(conditions) : Collections.emptyList();
        this.location = location;
        this.target = target;
        this.name = name;
        this.key = key;
    }

    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="conditions")
    public List<Condition> getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action action = (Action)o;
        if (!this.conditions.equals(action.conditions)) {
            return false;
        }
        if (this.key != null ? !this.key.equals(action.key) : action.key != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(action.location) : action.location != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(action.name) : action.name != null) {
            return false;
        }
        return !(this.target != null ? !this.target.equals(action.target) : action.target != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Action other) {
        Preconditions.checkNotNull((Object)other);
        int compare = ObjectUtils.compare((Comparable)((Object)this.key), (Comparable)((Object)other.key));
        if (compare == 0 && (compare = ObjectUtils.compare((Comparable)this.name, (Comparable)other.name)) == 0) {
            compare = ObjectUtils.compare((Comparable)((Object)this.target), (Comparable)((Object)other.target));
        }
        return compare;
    }

    public String toString() {
        return "Action{key='" + this.key + '\'' + ", name=" + this.name + ", target='" + this.target + '\'' + ", location='" + this.location + '\'' + ", conditions=" + this.conditions + '}';
    }
}

