/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.link;

import com.atlassian.hipchat.api.connect.descriptor.ConnectDescriptor;
import com.atlassian.plugins.hipchat.ao.AOHipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.link.HipChatAOLinkManager;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Date;

@VisibleForTesting
class HipChatLinkBuilder
implements HipChatAOLinkManager.Builder {
    @VisibleForTesting
    static final String ERROR_MESSAGE_TEMPLATE = "%s must be set!";
    private final boolean systemUserEnabled;
    private final AOHipChatLink existing;
    private final HipChatAOLinkManager linkManager;
    private final TransactionTemplate transactionTemplate;
    @VisibleForTesting
    String apiUrl;
    @VisibleForTesting
    Integer groupId;
    @VisibleForTesting
    String oAuthId;
    @VisibleForTesting
    String secretKey;
    @VisibleForTesting
    String token;
    @VisibleForTesting
    Date addonTokenExpiryDate;
    @VisibleForTesting
    String groupName;
    @VisibleForTesting
    String connectDescriptor;
    @VisibleForTesting
    String systemUser;
    @VisibleForTesting
    String systemPassword;
    @VisibleForTesting
    String systemUserToken;
    @VisibleForTesting
    Date systemUserTokenExpiryDate;
    @VisibleForTesting
    Integer id;

    HipChatLinkBuilder(boolean systemUserEnabled, HipChatAOLinkManager linkManager, TransactionTemplate transactionTemplate) {
        this(systemUserEnabled, null, linkManager, transactionTemplate);
    }

    public HipChatLinkBuilder(boolean systemUserEnabled, AOHipChatLink existing, HipChatAOLinkManager linkManager, TransactionTemplate transactionTemplate) {
        this.systemUserEnabled = systemUserEnabled;
        this.existing = existing;
        this.linkManager = linkManager;
        this.transactionTemplate = transactionTemplate;
        if (existing != null) {
            this.id = existing.getID();
            this.apiUrl = existing.getApiUrl();
            this.groupId = existing.getGroupId();
            this.oAuthId = existing.getOAuthId();
            this.secretKey = existing.getSecretKey();
            this.token = existing.getToken();
            this.addonTokenExpiryDate = existing.getAddonTokenExpiry();
            this.groupName = existing.getGroupName();
            this.connectDescriptor = existing.getConnectDescriptor();
            if (systemUserEnabled) {
                this.systemUser = existing.getSystemUser();
                this.systemPassword = existing.getSystemPassword();
                this.systemUserToken = existing.getSystemUserToken();
                this.systemUserTokenExpiryDate = existing.getSystemTokenExpiry();
            }
        }
    }

    @Override
    public HipChatAOLinkManager.Builder withApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withGroupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withOAuthId(String oAuthId) {
        this.oAuthId = oAuthId;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withToken(String token) {
        this.token = token;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withAddonTokenExpiryDate(Date addonTokenExpiryDate) {
        this.addonTokenExpiryDate = addonTokenExpiryDate;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withSystemUser(String systemUser) {
        this.systemUser = systemUser;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withSystemUserToken(String systemUserToken) {
        this.systemUserToken = systemUserToken;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withSystemUserTokenExpiry(Date systemUserTokenExpiry) {
        this.systemUserTokenExpiryDate = systemUserTokenExpiry;
        return this;
    }

    @Override
    public HipChatAOLinkManager.Builder withConnectDescriptor(ConnectDescriptor connectDescriptor) {
        Preconditions.checkNotNull((Object)connectDescriptor);
        this.connectDescriptor = connectDescriptor.toJson();
        return this;
    }

    @Override
    public AOHipChatLink buildAndSave() {
        this.checkRequiredFields();
        return (AOHipChatLink)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<AOHipChatLink>(){

            public AOHipChatLink doInTransaction() {
                return HipChatLinkBuilder.this.id != null ? HipChatLinkBuilder.this.update() : HipChatLinkBuilder.this.create();
            }
        });
    }

    private void checkRequiredFields() {
        Preconditions.checkNotNull((Object)this.apiUrl, (String)ERROR_MESSAGE_TEMPLATE, (Object)"apiUrl");
        Preconditions.checkNotNull((Object)this.groupId, (String)ERROR_MESSAGE_TEMPLATE, (Object)"groupId");
        Preconditions.checkNotNull((Object)this.oAuthId, (String)ERROR_MESSAGE_TEMPLATE, (Object)"oAuthId");
        Preconditions.checkNotNull((Object)this.secretKey, (String)ERROR_MESSAGE_TEMPLATE, (Object)"secretKey");
        Preconditions.checkNotNull((Object)this.token, (String)ERROR_MESSAGE_TEMPLATE, (Object)"token");
        Preconditions.checkNotNull((Object)this.addonTokenExpiryDate, (String)ERROR_MESSAGE_TEMPLATE, (Object)"addonTokenExpiryDate");
        Preconditions.checkNotNull((Object)this.connectDescriptor, (String)ERROR_MESSAGE_TEMPLATE, (Object)"connectDescriptor");
        if (this.systemUserEnabled) {
            Preconditions.checkNotNull((Object)this.systemUser, (String)ERROR_MESSAGE_TEMPLATE, (Object)"systemUser");
            Preconditions.checkNotNull((Object)this.systemPassword, (String)ERROR_MESSAGE_TEMPLATE, (Object)"systemPassword");
            Preconditions.checkNotNull((Object)this.systemUserToken, (String)ERROR_MESSAGE_TEMPLATE, (Object)"systemUserToken");
            Preconditions.checkNotNull((Object)this.systemUserTokenExpiryDate, (String)ERROR_MESSAGE_TEMPLATE, (Object)"systemUserTokenExpiryDate");
        }
    }

    private AOHipChatLink create() {
        return this.linkManager.saveNew(this.doBuild(this.linkManager.newInstance()));
    }

    private AOHipChatLink update() {
        return this.linkManager.saveExisting(this.doBuild((AOHipChatLink)this.linkManager.getLinkById(new HipChatLinkId(this.id)).getOrNull()));
    }

    private AOHipChatLink doBuild(AOHipChatLink link) {
        link.setApiUrl(this.apiUrl);
        link.setOAuthId(this.oAuthId);
        link.setToken(this.token);
        link.setSecretKey(this.secretKey);
        link.setGroupId(this.groupId);
        link.setAddonTokenExpiry(this.addonTokenExpiryDate);
        link.setGroupName(this.groupName);
        link.setSystemUser(this.systemUser);
        link.setSystemPassword(this.systemPassword);
        link.setSystemUserToken(this.systemUserToken);
        link.setSystemTokenExpiry(this.systemUserTokenExpiryDate);
        link.setConnectDescriptor(this.connectDescriptor);
        return link;
    }
}

