/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.link;

import com.atlassian.cache.compat.CacheFactory;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.session.SessionService;
import com.atlassian.plugins.hipchat.ao.AOHipChatLink;
import com.atlassian.plugins.hipchat.ao.ImmutableHipChatLink;
import com.atlassian.plugins.hipchat.ao.InternalHipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.events.HipChatServerRegisteredEvent;
import com.atlassian.plugins.hipchat.api.events.HipChatServerRegistrationUpdatedEvent;
import com.atlassian.plugins.hipchat.api.events.HipChatServerUnregisteredEvent;
import com.atlassian.plugins.hipchat.link.HipChatAOLinkManager;
import com.atlassian.plugins.hipchat.link.HipChatLinkBuilder;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.Date;

public class CachedHipChatAOLinkManager
implements HipChatAOLinkManager {
    private final EventPublisher eventPublisher;
    private final HipChatAOLinkManager hipChatAOLinkManager;
    private final CachedReference<InternalHipChatLink[]> hipchatLinks;
    private final TransactionTemplate transactionTemplate;

    public CachedHipChatAOLinkManager(EventPublisher eventPublisher, HipChatAOLinkManager hipChatAOLinkManager, CacheFactory cacheManager, TransactionTemplate transactionTemplate) {
        this.eventPublisher = eventPublisher;
        this.hipChatAOLinkManager = hipChatAOLinkManager;
        this.transactionTemplate = transactionTemplate;
        CacheSettings settings = new CacheSettingsBuilder().flushable().replicateViaInvalidation().build();
        this.hipchatLinks = cacheManager.getCachedReference(CachedHipChatAOLinkManager.class, "hipChatLinks", new LinksSupplier(hipChatAOLinkManager), settings);
    }

    @Override
    public void updateAddonToken(HipChatLinkId linkId, String token, Date expiryDate) {
        this.hipChatAOLinkManager.updateAddonToken(linkId, token, expiryDate);
        this.hipchatLinks.reset();
    }

    @Override
    public void updateSystemUserToken(HipChatLinkId linkId, String token, Date expiryDate) {
        this.hipChatAOLinkManager.updateSystemUserToken(linkId, token, expiryDate);
        this.hipchatLinks.reset();
    }

    @Override
    public void removeLinkById(HipChatLinkId linkId, boolean asPartOfReinstall) {
        Option<AOHipChatLink> linkById = this.getLinkById(linkId);
        linkById.foreach(link -> {
            this.hipChatAOLinkManager.removeLinkById(linkId, asPartOfReinstall);
            this.hipchatLinks.reset();
            this.eventPublisher.publish((Object)new HipChatServerUnregisteredEvent(linkId, link.getGroupId(), asPartOfReinstall));
        });
    }

    @Override
    public Option<AOHipChatLink> getLinkById(HipChatLinkId linkId) {
        return this.hipChatAOLinkManager.getLinkById(linkId);
    }

    @Override
    public Option<AOHipChatLink> getLinkByOAuthId(String oauthId) {
        return this.hipChatAOLinkManager.getLinkByOAuthId(oauthId);
    }

    @Override
    public Iterable<InternalHipChatLink> getLinks() {
        return ImmutableList.copyOf((Object[])this.hipchatLinks.get());
    }

    @Override
    public Option<AOHipChatLink> getLinkByUrlAndGroup(String apiUrl, int groupId) {
        return this.hipChatAOLinkManager.getLinkByUrlAndGroup(apiUrl, groupId);
    }

    @Override
    public SessionService makeSessionService(InternalHipChatLink aoHipChatLink, HipChatRoutesProvider.Routes<HipChatAPI.TokenType.CustomToken> routes, UserKey userKey) {
        return this.hipChatAOLinkManager.makeSessionService(aoHipChatLink, routes, userKey);
    }

    @Override
    public Option<HipChatAOLinkManager.Builder> newLinkBuilder(HipChatLinkId linkId) {
        return this.hipChatAOLinkManager.newLinkBuilder(linkId);
    }

    @Override
    public HipChatAOLinkManager.Builder newLinkBuilder(boolean systemUserEnabled) {
        return new HipChatLinkBuilder(systemUserEnabled, this, this.transactionTemplate);
    }

    @Override
    public HipChatAOLinkManager.Builder newLinkBuilder(boolean systemUserEnabled, AOHipChatLink existingLink) {
        return new HipChatLinkBuilder(systemUserEnabled, existingLink, this, this.transactionTemplate);
    }

    @Override
    public AOHipChatLink newInstance() {
        return this.hipChatAOLinkManager.newInstance();
    }

    @Override
    public AOHipChatLink saveNew(AOHipChatLink link) {
        AOHipChatLink savedLink = this.hipChatAOLinkManager.saveNew(link);
        this.hipchatLinks.reset();
        this.eventPublisher.publish((Object)new HipChatServerRegisteredEvent(new HipChatLinkId(link.getID()), link.getGroupId()));
        return savedLink;
    }

    @Override
    public AOHipChatLink saveExisting(AOHipChatLink link) {
        AOHipChatLink savedLink = this.hipChatAOLinkManager.saveExisting(link);
        this.hipchatLinks.reset();
        this.eventPublisher.publish((Object)new HipChatServerRegistrationUpdatedEvent(new HipChatLinkId(link.getID()), link.getGroupId()));
        return savedLink;
    }

    private static class LinksSupplier
    implements Supplier<InternalHipChatLink[]> {
        private final HipChatAOLinkManager linkManager;

        private LinksSupplier(HipChatAOLinkManager linkManager) {
            this.linkManager = linkManager;
        }

        @Override
        public InternalHipChatLink[] get() {
            Iterable transformedLink = Iterables.transform(this.linkManager.getLinks(), input -> new ImmutableHipChatLink((InternalHipChatLink)input));
            return (InternalHipChatLink[])Iterables.toArray((Iterable)transformedLink, InternalHipChatLink.class);
        }
    }
}

