/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.compat.legacy;

import com.atlassian.annotations.Internal;
import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.ResourceMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.plugins.hipchat.api.client.HipChatClientProvider;
import com.atlassian.plugins.hipchat.api.compat.legacy.HipChatConfiguration;
import com.atlassian.plugins.hipchat.api.compat.legacy.HipChatRoomsClient;
import com.atlassian.plugins.hipchat.api.compat.legacy.Message;
import com.atlassian.plugins.hipchat.api.compat.legacy.Room;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.representation.Form;
import io.atlassian.fugue.Option;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@Deprecated
@Internal
final class DefaultHipChatRoomsClient
implements HipChatRoomsClient {
    private final Client client;
    private final HipChatConfiguration defaultHipChatConfiguration;
    private final ClientResponseMapper responseMapper;

    public DefaultHipChatRoomsClient(HipChatClientProvider client, HipChatConfiguration defaultHipChatConfigurationManager, ClientResponseMapper responseMapper) {
        this.responseMapper = responseMapper;
        this.client = client.get();
        this.defaultHipChatConfiguration = defaultHipChatConfigurationManager;
    }

    @Override
    public Promise<Result<List<Room>>> list() {
        return ResourceMapper.toGetAsyncJsonResource(this.client).apply(this.buildUrl("rooms/list")).map(this.responseMapper.to(RoomsResponse.class)).recover(ResourceMapper.handleError()).map(result -> {
            if (result.isSuccess()) {
                return Result.success(((RoomsResponse)result.success()).rooms);
            }
            return result.asError();
        });
    }

    private URI buildUrl(String endpoint) {
        return UriBuilder.fromUri((String)this.defaultHipChatConfiguration.getApiBaseUrl()).path("v1").path(endpoint).queryParam("auth_token", new Object[]{this.defaultHipChatConfiguration.getApiToken().get()}).build(new Object[0]);
    }

    @Override
    public Promise<Result<Void>> message(String roomIdOrName, String from, String message, Option<Message.Format> format, Option<Message.BackgroundColor> color, Option<Boolean> notify) {
        Form params = DefaultHipChatRoomsClient.messageParametersAsMap(roomIdOrName, from, message, format, color, notify);
        return ResourceMapper.toPostAsyncFormResource(this.client, params).apply(this.buildUrl("rooms/message")).map(this.responseMapper.toVoid()).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<Room>> create(String name, long ownerId, Option<Boolean> privacy, Option<String> topic, Option<Boolean> enableGuestAccess) {
        return Promises.promise(Result.error(new UnsupportedOperationException("Not implemented, use API V2")));
    }

    @Override
    public Promise<Result<Void>> delete(String roomIdOrName) {
        return Promises.promise(Result.error(new UnsupportedOperationException("Not implemented, use API V2")));
    }

    private static Form messageParametersAsMap(String roomIdOrName, String from, String message, Option<Message.Format> format, Option<Message.BackgroundColor> color, Option<Boolean> notify) {
        Form params = new Form();
        params.putSingle("room_id", roomIdOrName);
        params.putSingle("from", from);
        params.putSingle("message", message);
        if (format.isDefined()) {
            params.putSingle("message_format", ((Message.Format)((Object)format.get())).value);
        }
        if (color.isDefined()) {
            params.putSingle("color", ((Message.BackgroundColor)((Object)color.get())).value);
        }
        if (notify.isDefined()) {
            params.putSingle("notify", (Boolean)notify.get() != false ? "1" : "0");
        }
        return params;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class RoomsResponse {
        private final List<Room> rooms;

        @JsonCreator
        public RoomsResponse(@JsonProperty(value="rooms") List<Room> rooms) {
            this.rooms = rooms;
        }
    }
}

