/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.compat.legacy;

import com.atlassian.annotations.Internal;
import com.atlassian.plugins.hipchat.api.compat.legacy.HipChatConfiguration;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;

@Deprecated
@Internal
public final class DefaultHipChatConfiguration
implements HipChatConfiguration {
    private static final String API_BASE_URI = "https://api.hipchat.com/";
    private static final String HIPCHAT_NODE_ENV_NAME = "hipchat_node";
    private static final String HIPCHAT_DEV_BASE_URL_FORMAT = "https://%s.hipchat.com/";
    private static final String HIPCHAT_BASE_URL_KEY = "hipchat-base-url";
    @VisibleForTesting
    public static final String HIPCHAT_AUTH_TOKEN_KEY = "hipchat-auth-token";
    @VisibleForTesting
    public static final String PLUGIN_STORAGE_KEY = "com.atlassian.labs.hipchat";
    private final PluginSettingsFactory pluginSettingsFactory;

    public DefaultHipChatConfiguration(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public final String getApiBaseUrl() {
        return ((String)this.getConfiguredBaseUrl().orElse(() -> this.getHipChatDevBaseUrl()).getOrElse((Object)API_BASE_URI)).trim();
    }

    private Option<String> getConfiguredBaseUrl() {
        return this.internalGet(HIPCHAT_BASE_URL_KEY);
    }

    private Option<String> getHipChatDevBaseUrl() {
        if (this.isDevMode()) {
            return this.getHipChatNodeName().map(node -> String.format(HIPCHAT_DEV_BASE_URL_FORMAT, node));
        }
        return Option.none();
    }

    private Option<String> getHipChatNodeName() {
        return Option.option((Object)System.getenv().get(HIPCHAT_NODE_ENV_NAME));
    }

    protected boolean isDevMode() {
        return Boolean.getBoolean("atlassian.dev.mode");
    }

    @Override
    public final void setApiBaseUrl(String baseUrl) {
        this.internalSet(HIPCHAT_BASE_URL_KEY, baseUrl);
    }

    @Override
    public final Option<String> getApiToken() {
        return this.internalGet(HIPCHAT_AUTH_TOKEN_KEY);
    }

    @Override
    public final void setApiToken(String token) {
        this.internalSet(HIPCHAT_AUTH_TOKEN_KEY, token);
    }

    @Override
    public boolean removeApiToken() {
        return this.getSettings().remove(HIPCHAT_AUTH_TOKEN_KEY) != null;
    }

    public final void set(String key, String value) {
        Preconditions.checkState((!HIPCHAT_BASE_URL_KEY.equals(key) ? 1 : 0) != 0);
        Preconditions.checkState((!HIPCHAT_AUTH_TOKEN_KEY.equals(key) ? 1 : 0) != 0);
        this.internalSet(key, value);
    }

    public final Option<String> get(String key) {
        Preconditions.checkState((!HIPCHAT_BASE_URL_KEY.equals(key) ? 1 : 0) != 0);
        Preconditions.checkState((!HIPCHAT_AUTH_TOKEN_KEY.equals(key) ? 1 : 0) != 0);
        return this.internalGet(key);
    }

    protected Option<String> internalGet(String key) {
        return Option.option((Object)((String)this.getSettings().get(key)));
    }

    private PluginSettings getSettings() {
        return this.pluginSettingsFactory.createSettingsForKey(PLUGIN_STORAGE_KEY);
    }

    protected void internalSet(String key, String value) {
        this.getSettings().put(key, (Object)value);
    }
}

