/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api;

import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.ErrorResponse;
import com.atlassian.hipchat.api.Result;
import com.atlassian.plugins.hipchat.ao.AOHipChatUser;
import com.atlassian.plugins.hipchat.user.HipChatAOUserManager;
import com.atlassian.sal.api.user.UserKey;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthInvalidatingClientResponseMapper
implements ClientResponseMapper {
    private final Logger logger = LoggerFactory.getLogger(OauthInvalidatingClientResponseMapper.class);
    private final ClientResponseMapper wrapped;
    private final HipChatAOUserManager hipChatAOUserManager;
    private final UserKey userKey;

    public OauthInvalidatingClientResponseMapper(ClientResponseMapper wrapped, HipChatAOUserManager hipChatAOUserManager, UserKey userKey) {
        this.wrapped = wrapped;
        this.hipChatAOUserManager = hipChatAOUserManager;
        this.userKey = userKey;
    }

    @Override
    public <T> Function<ClientResponse, Result<T>> to(Class<? extends T> clazz) {
        return input -> {
            Function<ClientResponse, Result<ClientResponse>> func = this.wrapped.to(clazz);
            return this.checkResult(func.apply((ClientResponse)input));
        };
    }

    private <T extends Result> T checkResult(T r) {
        if (r.isError()) {
            r.error().getErrorResponse().foreach(errorResponse -> {
                if (errorResponse.getError().getCode() == Response.Status.UNAUTHORIZED.getStatusCode() && errorResponse.getError().getMessage().contains("Invalid OAuth session") && this.userKey != null) {
                    this.hipChatAOUserManager.getByUserKey(this.userKey).foreach(aoHipChatUser -> {
                        this.logger.warn("The OAuth session between Hipchat and Jira for the user '" + this.userKey.getStringValue() + "' is not functioning. The user mapping will be deleted and the user will be asked to confirm access again. " + errorResponse.toString());
                        this.hipChatAOUserManager.delete((AOHipChatUser)aoHipChatUser);
                    });
                }
            });
        }
        return r;
    }

    public static boolean isOauthSessionBroken(ErrorResponse errorResponse) {
        return errorResponse.getError().getCode() == Response.Status.UNAUTHORIZED.getStatusCode() && errorResponse.getError().getMessage().contains("Invalid OAuth session");
    }

    @Override
    public <T> Function<ClientResponse, Result.CacheableResult<T>> conditionalTo(Class<T> clazz) {
        return input -> (Result.CacheableResult)this.checkResult((Result)this.wrapped.conditionalTo(clazz).apply((ClientResponse)input));
    }

    @Override
    public Function<ClientResponse, Result<Void>> toVoid() {
        return input -> this.checkResult(this.wrapped.toVoid().apply((ClientResponse)input));
    }

    @Override
    public <T> Function<ClientResponse, Result<T>> to(GenericType<? extends T> type) {
        return input -> {
            Function<ClientResponse, Result<ClientResponse>> func = this.wrapped.to(type);
            return this.checkResult(func.apply((ClientResponse)input));
        };
    }
}

