/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api;

import com.atlassian.hipchat.api.ResourceError;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.function.Function;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public abstract class Result<T> {
    public static <T> Result<T> success(T result) {
        return new Success<T>(result);
    }

    public static Result<Void> successVoid() {
        return new SuccessVoid();
    }

    public static <T> Result<T> error(Throwable error) {
        return new Error(new ResourceError(error));
    }

    public static <T> Result<T> error(String error) {
        return new Error(new ResourceError(new Exception(error)));
    }

    public static <T> Result<T> error(String error, int errorCode) {
        return new Error(new ResourceError(new Exception(error), errorCode));
    }

    public static <T> Result<T> error(ResourceError error) {
        return new Error(error);
    }

    public abstract Either<ResourceError, T> either();

    public abstract Option<T> option();

    public <V> Result<V> asError() {
        throw new IllegalStateException("Attempting to get error from success class");
    }

    @JsonIgnore
    public boolean isError() {
        return false;
    }

    @JsonProperty(value="isSuccess")
    public boolean isSuccess() {
        return false;
    }

    public ResourceError error() {
        throw new IllegalStateException("Attempting to get error from success class");
    }

    public T success() {
        throw new IllegalStateException("Attempting to get success from error class");
    }

    public <V> V fold(Function<? super ResourceError, V> ifLeft, Function<? super T, V> ifRight) {
        if (this.isSuccess()) {
            return ifRight.apply(this.success());
        }
        if (this.isError()) {
            return ifLeft.apply(this.error());
        }
        throw new IllegalStateException("Result is neither success nor error " + this);
    }

    private static class SuccessVoid
    extends Success<Void> {
        public SuccessVoid() {
            super(null);
        }

        @Override
        public Void success() {
            return null;
        }

        @Override
        public Either<ResourceError, Void> either() {
            throw new IllegalStateException("Either does not allow null values.");
        }

        @Override
        public ResourceError error() {
            throw new IllegalStateException("Attempting to get error from success class");
        }

        @Override
        public String toString() {
            return "Success()";
        }
    }

    private static class Success<T>
    extends Result<T> {
        private final T value;

        public Success(T value) {
            this.value = value;
        }

        @Override
        @JsonProperty(value="isSuccess")
        public boolean isSuccess() {
            return true;
        }

        @Override
        public T success() {
            return this.value;
        }

        @JsonProperty(value="value")
        private T getValue() {
            return this.value;
        }

        @Override
        public Either<ResourceError, T> either() {
            return Either.right(this.success());
        }

        @Override
        public Option<T> option() {
            return Option.some(this.success());
        }

        public boolean equals(Object obj) {
            return obj instanceof Success && this.value.equals(((Success)obj).value);
        }

        public String toString() {
            return "Success (" + this.value.toString() + ")";
        }
    }

    private static class NotModified<T>
    extends CacheableResult<T> {
        private NotModified() {
        }

        @Override
        public Either<ResourceError, T> either() {
            throw new IllegalAccessError("Unmodified Results do not contain an error or an entity.");
        }

        @Override
        public boolean isNotModified() {
            return true;
        }

        @Override
        public Option<T> option() {
            return Option.none();
        }
    }

    private static class Error<T>
    extends Result<T> {
        private final ResourceError value;

        public Error(ResourceError value) {
            this.value = value;
        }

        @Override
        @JsonProperty(value="isSuccess")
        public boolean isSuccess() {
            return false;
        }

        @Override
        public boolean isError() {
            return true;
        }

        @Override
        @JsonProperty(value="value")
        public ResourceError error() {
            return this.value;
        }

        @Override
        public Either<ResourceError, T> either() {
            return Either.left((Object)this.error());
        }

        @Override
        public <V> Result<V> asError() {
            return Result.error(this.value);
        }

        @Override
        public Option<T> option() {
            return Option.none();
        }

        public boolean equals(Object obj) {
            return obj instanceof Success && this.value.equals(((Success)obj).value);
        }

        public String toString() {
            return "Error (" + this.value.toString() + ")";
        }
    }

    private static class CacheableDelegateResult<T>
    extends CacheableResult<T> {
        private final Result<T> delegate;

        private CacheableDelegateResult(Result<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Either<ResourceError, T> either() {
            return this.delegate.either();
        }

        @Override
        public Option<T> option() {
            return this.delegate.option();
        }

        @Override
        public <V> Result<V> asError() {
            return this.delegate.asError();
        }

        @Override
        public boolean isError() {
            return this.delegate.isError();
        }

        @Override
        public boolean isSuccess() {
            return this.delegate.isSuccess();
        }

        @Override
        public ResourceError error() {
            return this.delegate.error();
        }

        @Override
        public T success() {
            return this.delegate.success();
        }
    }

    private static class CacheableSuccess<T>
    extends CacheableResult<T> {
        private final T value;
        private final Option<String> etag;

        public CacheableSuccess(T value, Option<String> etag) {
            this.value = value;
            this.etag = etag;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public Option<String> getEtag() {
            return this.etag;
        }

        @Override
        public T success() {
            return this.value;
        }

        @Override
        public Either<ResourceError, T> either() {
            return Either.left((Object)this.error());
        }

        @Override
        public Option<T> option() {
            return Option.some(this.success());
        }
    }

    public static abstract class CacheableResult<T>
    extends Result<T> {
        public static <T> CacheableResult<T> fromResult(Result<T> result) {
            return new CacheableDelegateResult(result);
        }

        public static <T> CacheableResult<T> notModified() {
            return new NotModified();
        }

        public static <T> CacheableResult<T> success(T result, Option<String> etag) {
            return new CacheableSuccess<T>(result, etag);
        }

        public boolean isNotModified() {
            return false;
        }

        public Option<String> getEtag() {
            return Option.none();
        }
    }
}

