/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.HipChatTokenReference;
import com.atlassian.hipchat.api.addons.AddonService;
import com.atlassian.hipchat.api.capabilities.CapabilitiesService;
import com.atlassian.hipchat.api.common.FeatureService;
import com.atlassian.hipchat.api.emoticons.EmoticonService;
import com.atlassian.hipchat.api.groups.GroupService;
import com.atlassian.hipchat.api.healthcheck.HealthCheckService;
import com.atlassian.hipchat.api.rooms.RoomService;
import com.atlassian.hipchat.api.session.SessionService;
import com.atlassian.hipchat.api.users.UserService;

@ExperimentalApi
public interface HipChatAPI<T extends TokenType> {
    public UserService users();

    public SessionService sessions();

    public HealthCheckService healthCheck();

    public CapabilitiesService capabilities();

    public RoomService rooms();

    public EmoticonService emoticons();

    public AddonService addons();

    public GroupService groups();

    public FeatureService features();

    public HipChatRoutesProvider.Routes<T> getRoutes();

    public HipChatTokenReference getToken();

    public TokenType getTokenType();

    public static interface TokenType {

        public static enum CustomToken implements TokenType
        {
            CustomToken;

        }

        public static enum PersonalToken implements TokenType
        {
            PersonalToken;

        }

        public static enum AddonToken implements TokenType
        {
            AddonToken;

        }

        public static enum SystemUserToken implements TokenType
        {
            SystemUserToken;

        }
    }
}

