/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api;

import com.atlassian.fugue.Effect;
import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.ErrorResponse;
import com.atlassian.hipchat.api.Result;
import com.atlassian.plugins.hipchat.ao.AOHipChatUser;
import com.atlassian.plugins.hipchat.user.HipChatAOUserManager;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Function;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OauthInvalidatingClientResponseMapper
implements ClientResponseMapper {
    private final Logger logger = LoggerFactory.getLogger(OauthInvalidatingClientResponseMapper.class);
    private final ClientResponseMapper wrapped;
    private final HipChatAOUserManager hipChatAOUserManager;
    private final UserKey userKey;

    public OauthInvalidatingClientResponseMapper(ClientResponseMapper wrapped, HipChatAOUserManager hipChatAOUserManager, UserKey userKey) {
        this.wrapped = wrapped;
        this.hipChatAOUserManager = hipChatAOUserManager;
        this.userKey = userKey;
    }

    @Override
    public <T> Function<ClientResponse, Result<T>> to(final Class<? extends T> clazz) {
        return new Function<ClientResponse, Result<T>>(){

            public Result<T> apply(ClientResponse input) {
                return OauthInvalidatingClientResponseMapper.this.checkResult((Result)OauthInvalidatingClientResponseMapper.this.wrapped.to(clazz).apply((Object)input));
            }
        };
    }

    private <T extends Result> T checkResult(T r) {
        if (r.isError()) {
            r.error().getErrorResponse().foreach((Effect)new Effect<ErrorResponse>(){

                public void apply(final ErrorResponse errorResponse) {
                    if (errorResponse.getError().getCode() == Response.Status.UNAUTHORIZED.getStatusCode() && errorResponse.getError().getMessage().contains("Invalid OAuth session") && OauthInvalidatingClientResponseMapper.this.userKey != null) {
                        OauthInvalidatingClientResponseMapper.this.hipChatAOUserManager.getByUserKey(OauthInvalidatingClientResponseMapper.this.userKey).foreach((Effect)new Effect<AOHipChatUser>(){

                            public void apply(AOHipChatUser aoHipChatUser) {
                                OauthInvalidatingClientResponseMapper.this.logger.warn("The OAuth session between HipChat and JIRA for the user '" + OauthInvalidatingClientResponseMapper.this.userKey.getStringValue() + "' is not functioning. The user mapping will be deleted and the user will be asked to confirm access again. " + errorResponse.toString());
                                OauthInvalidatingClientResponseMapper.this.hipChatAOUserManager.delete(aoHipChatUser);
                            }
                        });
                    }
                }
            });
        }
        return r;
    }

    public static boolean isOauthSessionBroken(ErrorResponse errorResponse) {
        return errorResponse.getError().getCode() == Response.Status.UNAUTHORIZED.getStatusCode() && errorResponse.getError().getMessage().contains("Invalid OAuth session");
    }

    @Override
    public <T> Function<ClientResponse, Result.CacheableResult<T>> conditionalTo(final Class<T> clazz) {
        return new Function<ClientResponse, Result.CacheableResult<T>>(){

            public Result.CacheableResult<T> apply(ClientResponse input) {
                return (Result.CacheableResult)OauthInvalidatingClientResponseMapper.this.checkResult((Result)OauthInvalidatingClientResponseMapper.this.wrapped.conditionalTo(clazz).apply((Object)input));
            }
        };
    }

    @Override
    public Function<ClientResponse, Result<Void>> toVoid() {
        return new Function<ClientResponse, Result<Void>>(){

            public Result<Void> apply(ClientResponse input) {
                return OauthInvalidatingClientResponseMapper.this.checkResult((Result)OauthInvalidatingClientResponseMapper.this.wrapped.toVoid().apply((Object)input));
            }
        };
    }

    @Override
    public <T> Function<ClientResponse, Result<T>> to(final GenericType<? extends T> type) {
        return new Function<ClientResponse, Result<T>>(){

            public Result<T> apply(ClientResponse input) {
                return OauthInvalidatingClientResponseMapper.this.checkResult((Result)OauthInvalidatingClientResponseMapper.this.wrapped.to(type).apply((Object)input));
            }
        };
    }
}

