/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.session;

import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.hipchat.api.ResourceMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.session.GenerateTokenResult;
import com.atlassian.hipchat.api.session.SessionResult;
import com.atlassian.hipchat.api.session.SessionService;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.SettableFuture;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.api.representation.Form;
import java.net.URI;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSessionService<T extends HipChatAPI.TokenType>
implements SessionService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSessionService.class);
    private final Client client;
    private final String oAuthID;
    private final String secret;
    private final HipChatRoutesProvider.Routes<T> routes;
    private final ClientResponseMapper mapper;

    public DefaultSessionService(Client client, String oAuthID, String Secret, HipChatRoutesProvider.Routes<T> routes, ClientResponseMapper mapper) {
        this.client = client;
        this.oAuthID = oAuthID;
        this.secret = Secret;
        this.routes = routes;
        this.mapper = mapper;
    }

    @Override
    public Promise<Result<GenerateTokenResult>> generateClientCredentialsToken(HipChatScope ... scopes) {
        Form form = new Form();
        form.putSingle("scope", StringUtils.join((Object[])scopes, (char)' '));
        form.putSingle("grant_type", "client_credentials");
        return this.generateToken(form, this.oAuthID, this.secret);
    }

    @Override
    public URI generateOauth2Uri(URI callback, String xsrfToken, HipChatScope ... scopes) {
        return this.routes.authorize(callback, this.oAuthID, xsrfToken, StringUtils.join((Object[])scopes, (char)' '));
    }

    @Override
    public Promise<Result<GenerateTokenResult>> generatePasswordToken(String username, String password, HipChatScope ... scopes) {
        Form form = new Form();
        form.putSingle("scope", StringUtils.join((Object[])scopes, (char)' '));
        form.putSingle("grant_type", "password");
        form.putSingle("username", username);
        form.putSingle("password", password);
        return this.generateToken(form, this.oAuthID, this.secret);
    }

    @Override
    public Promise<Result<GenerateTokenResult>> generateOauth2Token(String code, HipChatScope ... scopes) {
        Form form = new Form();
        form.putSingle("scope", StringUtils.join((Object[])scopes, (char)' '));
        form.putSingle("grant_type", "authorization_code");
        form.putSingle("code", code);
        return this.generateToken(form, this.oAuthID, this.secret);
    }

    @Override
    public Promise<Result<SessionResult>> getSession(String accessToken) {
        Promise response = this.routes.getSession(accessToken).flatMap(ResourceMapper.toGetAsyncJsonResource(this.client));
        return response.map(this.mapper.to(SessionResult.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<GenerateTokenResult>> generateRefreshToken(String systemUserRefreshCode) {
        Form form = new Form();
        form.putSingle("scope", HipChatScope.SendMessage.name());
        form.putSingle("grant_type", "refresh_token");
        form.putSingle("refresh_token", systemUserRefreshCode);
        return this.generateToken(form, this.oAuthID, this.secret);
    }

    @Override
    public Promise<Result<Void>> deleteSession(String accessToken) {
        return this.routes.deleteSession(accessToken).flatMap(ResourceMapper.toDeleteAsyncJsonResource(this.client)).map(this.mapper.toVoid()).recover(ResourceMapper.handleError());
    }

    private Promise<Result<GenerateTokenResult>> generateToken(Form form, String oAuthId, String secret) {
        URI generateTokenURI = this.routes.generateToken();
        logger.info("Generating token with URI " + generateTokenURI + " and form " + form + "...");
        AsyncWebResource resource = this.client.asyncResource(generateTokenURI);
        resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(oAuthId, secret));
        SettableFuture future = SettableFuture.create();
        resource.accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(ResourceMapper.async((SettableFuture<ClientResponse>)future), (Object)form);
        return ResourceMapper.forFuture(future).map(this.mapper.to(GenerateTokenResult.class)).recover(ResourceMapper.handleError());
    }
}

